/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.server.EndComboPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.Combo;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillBase;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

@SideOnly(value=Side.CLIENT)
public class ComboOverlay
extends Gui {
    private final Minecraft mc = Minecraft.getMinecraft();
    private Combo combo = null;
    private int lastComboSize = 0;
    private long displayStartTime;
    private static final long DISPLAY_TIME = 5000L;
    public static boolean shouldDisplay;

    public ComboOverlay() {
        shouldDisplay = Config.isComboHudEnabled;
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        DSSPlayerInfo skills = DSSPlayerInfo.get((EntityPlayer)this.mc.thePlayer);
        ICombo iCombo = skills.getComboSkill();
        if (iCombo != null && iCombo.getCombo() != null && this.combo != iCombo.getCombo()) {
            this.combo = iCombo.getCombo();
            this.displayStartTime = Minecraft.getSystemTime();
            if (iCombo.getCombo().isFinished()) {
                this.lastComboSize = this.combo.getNumHits();
                iCombo.setCombo(null);
                PacketDispatcher.sendToServer(new EndComboPacket((SkillBase)((Object)iCombo)));
            }
        }
        if (this.combo != null && this.combo.getNumHits() > 0) {
            if (this.lastComboSize != this.combo.getNumHits()) {
                this.lastComboSize = this.combo.getNumHits();
                this.displayStartTime = Minecraft.getSystemTime();
            }
            if (Minecraft.getSystemTime() - this.displayStartTime < 5000L) {
                if (shouldDisplay) {
                    String s = this.combo.isFinished() ? StatCollector.translateToLocal((String)"combo.finished") + "! " : StatCollector.translateToLocal((String)"combo.combo") + ": ";
                    this.mc.fontRenderer.drawString(s + this.combo.getLabel(), 10, 10, this.combo.isFinished() ? 9699539 : 0xEEEE00, true);
                    this.mc.fontRenderer.drawString(StatCollector.translateToLocal((String)"combo.size") + ": " + this.combo.getNumHits() + "/" + this.combo.getMaxNumHits(), 10, 20, 0xFFFFFF, true);
                    this.mc.fontRenderer.drawString(StatCollector.translateToLocal((String)"combo.damage") + ": " + String.format("%.1f", Float.valueOf(this.combo.getDamage())), 10, 30, 0xFFFFFF, true);
                    List<Float> damageList = this.combo.getDamageList();
                    for (int i = 0; i < damageList.size() && i < Config.getHitsToDisplay(); ++i) {
                        this.mc.fontRenderer.drawString(" +" + String.format("%.1f", damageList.get(damageList.size() - i - 1)), 10, 30 + this.mc.fontRenderer.FONT_HEIGHT * (i + 1), 0xFFFFFF, true);
                    }
                }
                if (skills.canUseSkill(SkillBase.endingBlow)) {
                    ICombo skill = skills.getComboSkill();
                    ILockOnTarget target = skills.getTargetingSkill();
                    if (skill != null && skill.isComboInProgress() && target != null && target.getCurrentTarget() == skill.getCombo().getLastEntityHit()) {
                        this.mc.fontRenderer.drawString(StatCollector.translateToLocal((String)"combo.ending"), event.resolution.getScaledWidth() / 2 - 15, 30, 0xFF0000, true);
                    }
                }
            }
        }
    }
}

