/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DSSCombatEvents;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.client.gui.ComboOverlay;
import dynamicswordskills.client.gui.GuiEndingBlowOverlay;
import dynamicswordskills.client.gui.IGuiOverlay;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.util.TargetUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

@SideOnly(value=Side.CLIENT)
public class DSSClientEvents {
    private final Minecraft mc;
    private final List<IGuiOverlay> overlays = new ArrayList<IGuiOverlay>();
    private final List<IGuiOverlay> rendered = new ArrayList<IGuiOverlay>();
    private int mouseKey;
    private boolean isAttackKey;
    private boolean isUseKey;

    public DSSClientEvents() {
        this.mc = Minecraft.getMinecraft();
        this.overlays.add(new ComboOverlay(this.mc));
        this.overlays.add(new GuiEndingBlowOverlay(this.mc));
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        for (IGuiOverlay overlay : this.overlays) {
            if (!overlay.shouldRender() || !overlay.renderOverlay(event.resolution, this.rendered)) continue;
            this.rendered.add(overlay);
        }
        this.rendered.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public static void performComboAttack(Minecraft mc, ILockOnTarget skill) {
        if (!mc.thePlayer.isUsingItem()) {
            mc.thePlayer.swingItem();
            DSSCombatEvents.setPlayerAttackTime((EntityPlayer)mc.thePlayer);
            if (skill instanceof ICombo && ((ICombo)((Object)skill)).onAttack((EntityPlayer)mc.thePlayer)) {
                Entity entity = TargetUtils.getMouseOverEntity();
                mc.playerController.attackEntity((EntityPlayer)mc.thePlayer, entity != null ? entity : skill.getCurrentTarget());
            }
        }
    }

    @SubscribeEvent
    public void onMouseChanged(MouseEvent event) {
        this.mouseKey = event.button - 100;
        this.isAttackKey = this.mouseKey == this.mc.gameSettings.keyBindAttack.getKeyCode();
        boolean bl = this.isUseKey = this.mouseKey == this.mc.gameSettings.keyBindUseItem.getKeyCode();
        if (event.button == -1 && event.dwheel == 0) {
            return;
        }
        if (!this.isAttackKey && !this.isUseKey) {
            if (event.buttonstate) {
                DSSKeyHandler.onKeyPressed(this.mc, this.mouseKey);
            }
            return;
        }
        DSSPlayerInfo skills = DSSPlayerInfo.get((EntityPlayer)this.mc.thePlayer);
        if (event.buttonstate || event.dwheel != 0) {
            if (this.isAttackKey) {
                if (skills.isSkillActive(SkillBase.spinAttack) && skills.getActiveSkill(SkillBase.spinAttack).isAnimating()) {
                    skills.getActiveSkill(SkillBase.spinAttack).keyPressed(this.mc, this.mc.gameSettings.keyBindAttack, (EntityPlayer)this.mc.thePlayer);
                    event.setCanceled(true);
                } else if (skills.isSkillActive(SkillBase.backSlice) && skills.getActiveSkill(SkillBase.backSlice).isAnimating()) {
                    skills.getActiveSkill(SkillBase.backSlice).keyPressed(this.mc, this.mc.gameSettings.keyBindAttack, (EntityPlayer)this.mc.thePlayer);
                    event.setCanceled(true);
                } else {
                    event.setCanceled(!skills.canInteract() || this.mc.thePlayer.attackTime > 0);
                }
            } else {
                event.setCanceled(!skills.canInteract());
            }
        }
        if (event.isCanceled() || !event.buttonstate) {
            return;
        }
        ILockOnTarget skill = skills.getTargetingSkill();
        if (skill != null && skill.isLockedOn()) {
            if (this.isAttackKey) {
                if (Config.allowVanillaControls()) {
                    if (!skills.onKeyPressed(this.mc, this.mc.gameSettings.keyBindAttack)) {
                        DSSClientEvents.performComboAttack(this.mc, skill);
                    }
                    if (skills.hasSkill(SkillBase.armorBreak)) {
                        skills.getActiveSkill(SkillBase.armorBreak).keyPressed(this.mc, this.mc.gameSettings.keyBindAttack, (EntityPlayer)this.mc.thePlayer);
                    }
                }
                event.setCanceled(true);
            } else if (this.isUseKey && Config.allowVanillaControls()) {
                event.setCanceled(!skills.canInteract());
            }
        } else if (this.isAttackKey) {
            DSSCombatEvents.setPlayerAttackTime((EntityPlayer)this.mc.thePlayer);
        }
    }
}

