/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.gui.AbstractGuiOverlay;
import dynamicswordskills.client.gui.IGuiOverlay;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.server.EndComboPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.Combo;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.SkillBase;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;

@SideOnly(value=Side.CLIENT)
public class ComboOverlay
extends AbstractGuiOverlay {
    private Combo combo = null;
    private String label;
    private String comboSize;
    private String comboDamage;
    private int lastComboSize = 0;
    private long displayStartTime;
    private static final long DISPLAY_TIME = 5000L;

    public ComboOverlay(Minecraft mc) {
        super(mc);
    }

    @Override
    public IGuiOverlay.HALIGN getHorizontalAlignment() {
        return Config.comboHudHAlign;
    }

    @Override
    public IGuiOverlay.VALIGN getVerticalAlignment() {
        return Config.comboHudVAlign;
    }

    @Override
    public boolean allowMergeX(boolean rendered) {
        return false;
    }

    @Override
    public boolean shouldRender() {
        if (!Config.isComboHudEnabled) {
            return false;
        }
        ICombo iCombo = DSSPlayerInfo.get((EntityPlayer)this.mc.thePlayer).getComboSkill();
        if (iCombo != null && iCombo.getCombo() != null && this.combo != iCombo.getCombo()) {
            this.combo = iCombo.getCombo();
            this.lastComboSize = this.combo.getNumHits();
            this.displayStartTime = Minecraft.getSystemTime();
            if (this.combo.isFinished()) {
                iCombo.setCombo(null);
                PacketDispatcher.sendToServer(new EndComboPacket((SkillBase)((Object)iCombo)));
            }
        }
        if (this.combo != null && this.combo.getNumHits() > 0) {
            if (this.lastComboSize != this.combo.getNumHits()) {
                this.lastComboSize = this.combo.getNumHits();
                this.displayStartTime = Minecraft.getSystemTime();
            }
            return Minecraft.getSystemTime() - this.displayStartTime < 5000L;
        }
        return false;
    }

    @Override
    protected void setup(ScaledResolution resolution) {
        int n = Math.min(this.combo.getDamageList().size(), Config.getHitsToDisplay());
        this.height = (n + 3) * this.mc.fontRenderer.FONT_HEIGHT;
        this.label = this.combo.isFinished() ? StatCollector.translateToLocalFormatted((String)"combo.finished", (Object[])new Object[]{this.combo.getLabel()}) : StatCollector.translateToLocalFormatted((String)"combo.combo", (Object[])new Object[]{this.combo.getLabel()});
        this.comboSize = StatCollector.translateToLocalFormatted((String)"combo.size", (Object[])new Object[]{this.combo.getNumHits(), this.combo.getMaxNumHits()});
        this.comboDamage = StatCollector.translateToLocalFormatted((String)"combo.damage", (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.combo.getDamage()))});
        this.width = Math.max(this.mc.fontRenderer.getStringWidth(this.label), this.mc.fontRenderer.getStringWidth(this.comboDamage));
        this.setPosX(resolution, this.getOffsetX(2) + Config.comboHudOffsetX);
        this.setPosY(resolution, this.getOffsetY(2) + Config.comboHudOffsetY);
    }

    @Override
    protected void render(ScaledResolution resolution) {
        int xPos = this.getLeft();
        int yPos = this.getTop();
        this.mc.fontRenderer.drawString(this.label, xPos, yPos, this.combo.isFinished() ? 9699539 : 0xEEEE00, true);
        this.mc.fontRenderer.drawString(this.comboSize, xPos + this.getOffset(this.comboSize), yPos += this.mc.fontRenderer.FONT_HEIGHT, 0xFFFFFF, true);
        this.mc.fontRenderer.drawString(this.comboDamage, xPos + this.getOffset(this.comboDamage), yPos += this.mc.fontRenderer.FONT_HEIGHT, 0xFFFFFF, true);
        List<Float> damageList = this.combo.getDamageList();
        int n = Math.min(damageList.size(), Config.getHitsToDisplay());
        for (int i = 0; i < n; ++i) {
            String s = String.format("+%.1f", damageList.get(damageList.size() - i - 1));
            this.mc.fontRenderer.drawString(s, xPos + this.getOffset(s), yPos += this.mc.fontRenderer.FONT_HEIGHT, 0xFFFFFF, true);
        }
    }

    private int getOffset(String s) {
        switch (this.getHorizontalAlignment()) {
            case LEFT: {
                return 2;
            }
            case CENTER: {
                return this.getWidth() / 2 - this.mc.fontRenderer.getStringWidth(s) / 2;
            }
            case RIGHT: {
                return this.getWidth() - this.mc.fontRenderer.getStringWidth(s) - 2;
            }
        }
        return 0;
    }
}

