/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.gui.AbstractGuiOverlay;
import dynamicswordskills.client.gui.IGuiOverlay;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.EndingBlow;
import dynamicswordskills.skills.SkillActive;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;

@SideOnly(value=Side.CLIENT)
public class GuiEndingBlowOverlay
extends AbstractGuiOverlay {
    private long displayStartTime;
    private static final long DISPLAY_TIME = 1000L;

    public GuiEndingBlowOverlay(Minecraft mc) {
        super(mc);
    }

    @Override
    public IGuiOverlay.HALIGN getHorizontalAlignment() {
        return Config.endingBlowHudHAlign;
    }

    @Override
    public IGuiOverlay.VALIGN getVerticalAlignment() {
        return Config.endingBlowHudVAlign;
    }

    @Override
    public boolean shouldRender() {
        if (!Config.isEndingBlowHudEnabled) {
            return false;
        }
        SkillActive skill = DSSPlayerInfo.get((EntityPlayer)this.mc.thePlayer).getActiveSkill(SkillActive.endingBlow);
        if (skill == null) {
            this.displayStartTime = 0L;
        } else if (skill.canUse((EntityPlayer)this.mc.thePlayer)) {
            this.displayStartTime = Minecraft.getSystemTime();
        } else if (((EndingBlow)skill).getLastActivationTime() < this.displayStartTime) {
            this.displayStartTime = 0L;
        }
        return Minecraft.getSystemTime() - this.displayStartTime < 1000L;
    }

    @Override
    protected void setup(ScaledResolution resolution) {
        this.height = this.mc.fontRenderer.FONT_HEIGHT;
        this.width = this.mc.fontRenderer.getStringWidth(StatCollector.translateToLocal((String)"combo.ending"));
        this.setPosX(resolution, Config.endingBlowHudOffsetX);
        this.setPosY(resolution, Config.endingBlowHudOffsetY);
    }

    @Override
    protected void render(ScaledResolution resolution) {
        this.mc.fontRenderer.drawString(StatCollector.translateToLocal((String)"combo.ending"), this.x, this.y, 0xFF0000, true);
    }
}

