/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.entity;

import dynamicswordskills.util.DamageUtils;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class EntityLeapingBlow
extends EntityThrowable {
    private List<Integer> affectedEntities = new ArrayList<Integer>();
    private float damage = 2.0f;
    private int lifespan = 12;
    private int level = 0;
    private static final float BASE_SIZE = 1.0f;
    private static final float HEIGHT = 0.5f;

    public EntityLeapingBlow(World world) {
        super(world);
        this.setSize(1.0f, 0.5f);
    }

    public EntityLeapingBlow(World world, EntityLivingBase thrower) {
        super(world, thrower);
        this.setSize(1.0f, 0.5f);
        this.posY = thrower.posY + 0.2;
        this.motionY = 0.0;
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, this.func_70182_d(), 1.0f);
    }

    public EntityLeapingBlow(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.setSize(1.0f, 0.5f);
    }

    public EntityLeapingBlow setLevel(int level) {
        this.level = level;
        this.lifespan += level;
        return this;
    }

    public EntityLeapingBlow setDamage(float amount) {
        this.damage = amount;
        return this;
    }

    private double getRangeSquared() {
        return (3.0 + (double)this.level) * (3.0 + (double)this.level);
    }

    private int getPotionDuration() {
        return 50 + this.level * 10;
    }

    private AxisAlignedBB getAoE() {
        return this.boundingBox.expand((double)(0.25f * (float)this.level), 0.0, (double)(0.25f * (float)this.level));
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.inGround || this.ticksExisted > this.lifespan) {
            this.setDead();
        }
        if (!this.worldObj.isRemote) {
            List targets = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, this.getAoE());
            for (EntityLivingBase target : targets) {
                double d0;
                if (this.affectedEntities.contains(target.getEntityId()) || target == this.getThrower() || TargetUtils.isTargetInFrontOf((Entity)this, (Entity)target, 30.0f)) continue;
                this.affectedEntities.add(target.getEntityId());
                float d = this.damage;
                if (this.getThrower() != null && (double)(d = (float)((double)d * ((d0 = 1.0 - this.getThrower().getDistanceSqToEntity((Entity)target) / this.getRangeSquared()) > 1.0 ? 1.0 : d0))) < 0.5) {
                    return;
                }
                if (!target.attackEntityFrom(DamageUtils.causeIndirectSwordDamage((Entity)this, (Entity)this.getThrower()), d)) continue;
                target.addPotionEffect(new PotionEffect(Potion.weakness.id, this.getPotionDuration()));
            }
        }
        double vX = this.motionZ;
        double vZ = this.motionX;
        String particle = "crit";
        Block block = this.worldObj.getBlock((int)(this.posX + (this.boundingBox.maxX - this.boundingBox.minX) / 2.0), (int)this.posY - 1, (int)(this.posZ + (this.boundingBox.maxZ - this.boundingBox.minZ) / 2.0));
        if (block.getMaterial() != Material.air) {
            particle = "blockcrack_" + Block.getIdFromBlock((Block)block) + "_" + this.worldObj.getBlockMetadata((int)(this.posX + (this.boundingBox.maxX - this.boundingBox.minX) / 2.0), (int)this.posY - 1, (int)(this.posZ + (this.boundingBox.maxZ - this.boundingBox.minZ) / 2.0));
        }
        for (int i = 0; i < 4; ++i) {
            this.worldObj.spawnParticle(particle, this.posX, this.posY, this.posZ, vX + this.rand.nextGaussian(), 0.01, vZ + this.rand.nextGaussian());
            this.worldObj.spawnParticle(particle, this.posX, this.posY, this.posZ, -vX + this.rand.nextGaussian(), 0.01, -vZ + this.rand.nextGaussian());
        }
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (!this.worldObj.isRemote) {
            if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
                Entity entity = mop.entityHit;
                if (entity instanceof EntityLivingBase && !this.affectedEntities.contains(entity.getEntityId()) && entity != this.getThrower()) {
                    this.affectedEntities.add(entity.getEntityId());
                    if (entity.attackEntityFrom(DamageUtils.causeIndirectSwordDamage((Entity)this, (Entity)this.getThrower()), this.damage)) {
                        PlayerUtils.playSoundAtEntity(this.worldObj, entity, "dynamicswordskills:hurtflesh", 0.4f, 0.5f);
                        if (entity instanceof EntityLivingBase) {
                            ((EntityLivingBase)entity).addPotionEffect(new PotionEffect(Potion.weakness.id, 60));
                        }
                    }
                }
            } else {
                Block block = this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
                if (block.getMaterial().blocksMovement()) {
                    this.setDead();
                }
            }
        }
    }

    protected float func_70182_d() {
        return 0.5f;
    }

    public float getGravityVelocity() {
        return 0.0f;
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setFloat("damage", this.damage);
        compound.setInteger("level", this.level);
        compound.setInteger("lifespan", this.lifespan);
        compound.setIntArray("affectedEntities", ArrayUtils.toPrimitive((Integer[])this.affectedEntities.toArray(new Integer[this.affectedEntities.size()])));
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.damage = compound.getFloat("damage");
        this.level = compound.getInteger("level");
        this.lifespan = compound.getInteger("lifespan");
        int[] entities = compound.getIntArray("affectedEntities");
        for (int i = 0; i < entities.length; ++i) {
            this.affectedEntities.add(entities[i]);
        }
    }
}

