/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.SwordBeam;
import dynamicswordskills.util.DamageUtils;
import dynamicswordskills.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntitySwordBeam
extends EntityThrowable {
    private float damage = 4.0f;
    private int level = 1;
    private int lifespan = 12;

    public EntitySwordBeam(World world) {
        super(world);
    }

    public EntitySwordBeam(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntitySwordBeam(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void entityInit() {
        this.setSize(0.5f, 0.5f);
    }

    public EntitySwordBeam setLevel(int level) {
        this.level = level;
        this.lifespan += level;
        return this;
    }

    public EntitySwordBeam setDamage(float amount) {
        this.damage = amount;
        return this;
    }

    protected float func_70182_d() {
        return 1.0f + (float)this.level * 0.15f;
    }

    public float getGravityVelocity() {
        return 0.0f;
    }

    public float getBrightness(float partialTick) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float partialTick) {
        return 0xF000F0;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.inGround || this.ticksExisted > this.lifespan) {
            this.setDead();
        }
        for (int i = 0; i < 2; ++i) {
            this.worldObj.spawnParticle(i % 2 == 1 ? "magicCrit" : "crit", this.posX, this.posY, this.posZ, this.motionX + this.rand.nextGaussian(), 0.01, this.motionZ + this.rand.nextGaussian());
            this.worldObj.spawnParticle(i % 2 == 1 ? "magicCrit" : "crit", this.posX, this.posY, this.posZ, -this.motionX + this.rand.nextGaussian(), 0.01, -this.motionZ + this.rand.nextGaussian());
        }
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (!this.worldObj.isRemote) {
            SwordBeam skill;
            EntityPlayer player = this.getThrower() instanceof EntityPlayer ? (EntityPlayer)this.getThrower() : null;
            SwordBeam swordBeam = skill = player != null ? (SwordBeam)DSSPlayerInfo.get(player).getPlayerSkill(SkillBase.swordBeam) : null;
            if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
                Entity entity = mop.entityHit;
                if (entity == player) {
                    return;
                }
                if (player != null) {
                    if (skill != null) {
                        skill.onImpact(player, false);
                    }
                    if (entity.attackEntityFrom(DamageUtils.causeIndirectComboDamage((Entity)this, (Entity)player).setProjectile(), this.damage)) {
                        PlayerUtils.playSoundAtEntity(this.worldObj, entity, "dynamicswordskills:hurtflesh", 0.4f, 0.5f);
                    }
                    this.damage *= 0.8f;
                }
                if (this.level < SkillBase.swordBeam.getMaxLevel()) {
                    this.setDead();
                }
            } else {
                Block block = this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
                if (block.getMaterial().blocksMovement()) {
                    if (player != null && skill != null) {
                        skill.onImpact(player, true);
                    }
                    this.setDead();
                }
            }
        }
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setFloat("damage", this.damage);
        compound.setInteger("level", this.level);
        compound.setInteger("lifespan", this.lifespan);
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.damage = compound.getFloat("damage");
        this.level = compound.getInteger("level");
        this.lifespan = compound.getInteger("lifespan");
    }
}

