/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.util.PlayerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSkillOrb
extends Item {
    @SideOnly(value=Side.CLIENT)
    private List<IIcon> icons;

    public ItemSkillOrb() {
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.setCreativeTab(DynamicSwordSkills.tabSkills);
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        SkillBase skill;
        if (!player.worldObj.isRemote && (skill = SkillBase.getSkill(stack.getItemDamage())) != null) {
            if (!Config.isSkillEnabled(skill.getId())) {
                PlayerUtils.sendTranslatedChat(player, "chat.dss.skill.use.disabled", new ChatComponentTranslation(skill.getTranslationString(), new Object[0]));
            } else if (DSSPlayerInfo.get(player).grantSkill(skill)) {
                PlayerUtils.playSound(player, "dynamicswordskills:levelup", 1.0f, 1.0f);
                PlayerUtils.sendTranslatedChat(player, "chat.dss.skill.levelup", new ChatComponentTranslation(skill.getTranslationString(), new Object[0]), DSSPlayerInfo.get(player).getTrueSkillLevel(skill));
                if (!player.capabilities.isCreativeMode) {
                    --stack.stackSize;
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.dss.skill.maxlevel", new ChatComponentTranslation(skill.getTranslationString(), new Object[0]));
            }
        }
        return stack;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        SkillBase skill = SkillBase.getSkill(stack.getItemDamage());
        return StatCollector.translateToLocalFormatted((String)(super.getUnlocalizedName() + ".name"), (Object[])new Object[]{skill == null ? "" : skill.getDisplayName()});
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int damage) {
        return this.icons.get(damage % this.icons.size());
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (SkillBase skill : SkillBase.getSkills()) {
            list.add(new ItemStack(item, 1, (int)skill.getId()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new ArrayList<IIcon>(SkillBase.getNumSkills());
        for (SkillBase skill : SkillBase.getSkills()) {
            this.icons.add(register.registerIcon(skill.getIconTexture()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        SkillBase skill;
        if (SkillBase.doesSkillExist(stack.getItemDamage()) && (skill = DSSPlayerInfo.get(player).getPlayerSkill(SkillBase.getSkill(stack.getItemDamage()))) != null) {
            if (!Config.isSkillEnabled(skill.getId())) {
                list.add(EnumChatFormatting.DARK_RED + StatCollector.translateToLocal((String)"skill.dss.disabled"));
            } else if (skill.getLevel() > 0) {
                list.add(EnumChatFormatting.GOLD + skill.getLevelDisplay(true));
                list.addAll(skill.getTranslatedTooltip(player));
            } else {
                list.add(EnumChatFormatting.ITALIC + StatCollector.translateToLocal((String)"tooltip.dss.skillorb.desc.0"));
            }
        }
    }
}

