/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network.server;

import cpw.mods.fml.relauncher.Side;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractMessage;
import dynamicswordskills.skills.Dash;
import dynamicswordskills.skills.SkillBase;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.MovingObjectPosition;

public class DashImpactPacket
extends AbstractMessage.AbstractServerMessage<DashImpactPacket> {
    private byte hitType;
    private int entityId;

    public DashImpactPacket() {
    }

    public DashImpactPacket(EntityPlayer player, MovingObjectPosition mop) {
        this.hitType = (byte)mop.typeOfHit.ordinal();
        if (this.hitType == MovingObjectPosition.MovingObjectType.ENTITY.ordinal()) {
            this.entityId = mop.entityHit.getEntityId();
        }
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.hitType = buffer.readByte();
        if (this.hitType == MovingObjectPosition.MovingObjectType.ENTITY.ordinal()) {
            this.entityId = buffer.readInt();
        }
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeByte((int)this.hitType);
        if (this.hitType == MovingObjectPosition.MovingObjectType.ENTITY.ordinal()) {
            buffer.writeInt(this.entityId);
        }
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        Dash dash = (Dash)DSSPlayerInfo.get(player).getActiveSkill(SkillBase.dash);
        if (dash != null && dash.isActive()) {
            MovingObjectPosition mop = null;
            if (this.hitType == MovingObjectPosition.MovingObjectType.ENTITY.ordinal()) {
                Entity entityHit = player.worldObj.getEntityByID(this.entityId);
                if (entityHit != null) {
                    mop = new MovingObjectPosition(entityHit);
                } else {
                    DynamicSwordSkills.logger.warn("Could not retrieve valid entity for MovingObjectPosition while handling Dash Packet!");
                }
            }
            dash.onImpact(player.worldObj, player, mop);
        }
    }
}

