/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.DSSClientEvents;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.network.bidirectional.AttackTimePacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EndingBlow
extends SkillActive {
    private int activeTimer = 0;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    @SideOnly(value=Side.CLIENT)
    private int keyPressed;
    @SideOnly(value=Side.CLIENT)
    private long lastActivationTime;
    private int lastNumHits;
    private EntityLivingBase entityHit;
    private int xp;

    public EndingBlow(String name) {
        super(name);
    }

    private EndingBlow(EndingBlow skill) {
        super(skill);
    }

    @Override
    public EndingBlow newInstance() {
        return new EndingBlow(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.level * 20, true) + "%");
        desc.add(this.getDurationDisplay(this.getDuration(), true));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - (float)this.level * 0.1f;
    }

    public int getDuration() {
        return 45 - this.level * 5;
    }

    @SideOnly(value=Side.CLIENT)
    public long getLastActivationTime() {
        return this.lastActivationTime;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        if (!this.isActive() && super.canUse(player) && PlayerUtils.isWeapon(player.getHeldItem())) {
            ICombo combo = DSSPlayerInfo.get(player).getComboSkill();
            ILockOnTarget lock = DSSPlayerInfo.get(player).getTargetingSkill();
            if (combo != null && combo.isComboInProgress() && lock != null && lock.getCurrentTarget() == combo.getCombo().getLastEntityHit()) {
                if (this.lastNumHits > 0) {
                    return combo.getCombo().getConsecutiveHits() > 1 && combo.getCombo().getNumHits() > this.lastNumHits + 2;
                }
                return combo.getCombo().getConsecutiveHits() > 1;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.ticksTilFail > 0 && this.keyPressed > 1 && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == mc.gameSettings.keyBindForward || key == DSSKeyHandler.keys[2] || Config.allowVanillaControls() && key == mc.gameSettings.keyBindAttack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == mc.gameSettings.keyBindForward) {
            if (this.ticksTilFail == 0) {
                this.ticksTilFail = 6;
            }
            ++this.keyPressed;
        } else if (this.canExecute(player)) {
            this.ticksTilFail = 0;
            this.keyPressed = 0;
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.activeTimer = 3;
        ICombo skill = DSSPlayerInfo.get(player).getComboSkill();
        if (skill.getCombo() != null) {
            this.lastNumHits = skill.getCombo().getNumHits();
        }
        if (world.isRemote) {
            DSSClientEvents.performComboAttack(Minecraft.getMinecraft(), DSSPlayerInfo.get(player).getTargetingSkill());
            this.lastActivationTime = Minecraft.getSystemTime();
            this.ticksTilFail = 0;
            this.keyPressed = 0;
        }
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.activeTimer = 0;
        this.entityHit = null;
        this.xp = 0;
        if (world.isRemote) {
            this.keyPressed = 0;
            this.ticksTilFail = 0;
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (player.worldObj.isRemote && this.ticksTilFail > 0) {
            --this.ticksTilFail;
            if (this.ticksTilFail == 0) {
                this.keyPressed = 0;
            }
        }
        if (this.lastNumHits > 0) {
            ICombo skill;
            if (this.entityHit != null && this.xp > 0) {
                this.updateEntityState(player);
            }
            if ((skill = DSSPlayerInfo.get(player).getComboSkill()) == null || !skill.isComboInProgress()) {
                this.lastNumHits = 0;
            }
        }
        if (this.isActive()) {
            --this.activeTimer;
            if (this.activeTimer == 0 && !player.worldObj.isRemote && !player.capabilities.isCreativeMode) {
                player.attackTime = this.getDuration() * 2;
                PacketDispatcher.sendTo(new AttackTimePacket(player.attackTime), (EntityPlayerMP)player);
            }
        }
    }

    private void updateEntityState(EntityPlayer player) {
        if (!player.worldObj.isRemote) {
            if (this.entityHit.getHealth() <= 0.0f) {
                if (this.entityHit instanceof EntityLiving) {
                    DirtyEntityAccessor.setLivingXp((EntityLiving)this.entityHit, this.xp, true);
                } else {
                    PlayerUtils.spawnXPOrbsWithRandom(player.worldObj, player.worldObj.rand, MathHelper.floor_double((double)this.entityHit.posX), MathHelper.floor_double((double)this.entityHit.posY), MathHelper.floor_double((double)this.entityHit.posZ), this.xp);
                }
            } else {
                PlayerUtils.playSoundAtEntity(player.worldObj, (Entity)player, "dynamicswordskills:hurtflesh", 0.3f, 0.8f);
                if (!player.worldObj.isRemote && !player.capabilities.isCreativeMode) {
                    player.attackTime = this.getDuration();
                    PacketDispatcher.sendTo(new AttackTimePacket(player.attackTime), (EntityPlayerMP)player);
                }
            }
        }
        this.entityHit = null;
        this.xp = 0;
    }

    @Override
    public float postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        this.activeTimer = 0;
        ICombo combo = DSSPlayerInfo.get(player).getComboSkill();
        ILockOnTarget lock = DSSPlayerInfo.get(player).getTargetingSkill();
        if (combo != null && combo.isComboInProgress() && lock != null && lock.getCurrentTarget() == combo.getCombo().getLastEntityHit()) {
            amount *= 1.0f + (float)this.level * 0.2f;
            PlayerUtils.playSoundAtEntity(player.worldObj, (Entity)player, "dynamicswordskills:mortaldraw", 0.4f, 0.5f);
            this.entityHit = entity;
            this.xp = this.level + 1 + player.worldObj.rand.nextInt(Math.max(2, MathHelper.ceiling_float_int((float)entity.getHealth())));
        }
        return amount;
    }
}

