/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.network.bidirectional.DeactivateSkillPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class SkillActive
extends SkillBase {
    protected SkillActive(String name) {
        super(name, true);
    }

    protected SkillActive(SkillActive skill) {
        super(skill);
    }

    protected boolean allowUserActivation() {
        return true;
    }

    public abstract boolean isActive();

    protected abstract float getExhaustion();

    protected boolean autoAddExhaustion() {
        return true;
    }

    @Override
    protected void levelUp(EntityPlayer player) {
    }

    public boolean canUse(EntityPlayer player) {
        return this.level > 0 && (player.capabilities.isCreativeMode || player.getFoodStats().getFoodLevel() > 0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        return false;
    }

    protected boolean sendClientUpdate() {
        return true;
    }

    protected abstract boolean onActivated(World var1, EntityPlayer var2);

    protected abstract void onDeactivated(World var1, EntityPlayer var2);

    public final boolean activate(World world, EntityPlayer player) {
        return this.allowUserActivation() ? this.trigger(world, player, false) : false;
    }

    public final void deactivate(EntityPlayer player) throws IllegalStateException {
        if (this.isActive()) {
            this.onDeactivated(player.worldObj, player);
            if (this.isActive()) {
                DynamicSwordSkills.logger.error(this.getDisplayName() + " is still active after onDeactivated called - this may result in SEVERE errors or even crashes!!!");
            } else if (player.worldObj.isRemote) {
                PacketDispatcher.sendToServer(new DeactivateSkillPacket(this));
            } else {
                PacketDispatcher.sendTo(new DeactivateSkillPacket(this), (EntityPlayerMP)player);
            }
        }
    }

    public final boolean trigger(World world, EntityPlayer player, boolean wasTriggered) {
        if (!Config.isSkillEnabled(this.getId())) {
            PlayerUtils.sendTranslatedChat(player, "chat.dss.skill.use.disabled", new ChatComponentTranslation(this.getTranslationString(), new Object[0]));
            return false;
        }
        if (this.canUse(player)) {
            if (this.autoAddExhaustion() && !player.capabilities.isCreativeMode) {
                player.addExhaustion(this.getExhaustion());
            }
            if (!world.isRemote && this.sendClientUpdate()) {
                PacketDispatcher.sendTo(new ActivateSkillPacket(this, wasTriggered), (EntityPlayerMP)player);
            }
            return this.onActivated(world, player);
        }
        if (this.level > 0) {
            PlayerUtils.sendTranslatedChat(player, "chat.dss.skill.use.fail", new ChatComponentTranslation(this.getTranslationString(), new Object[0]));
        }
        return false;
    }

    public boolean hasAnimation() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.isActive();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        return false;
    }

    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        return false;
    }

    public float postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        return amount;
    }

    @Override
    public final void writeToNBT(NBTTagCompound compound) {
        compound.setByte("id", this.getId());
        compound.setByte("level", this.level);
    }

    @Override
    public final void readFromNBT(NBTTagCompound compound) {
        this.level = compound.getByte("level");
    }

    @Override
    public final SkillActive loadFromNBT(NBTTagCompound compound) {
        SkillActive skill = (SkillActive)SkillActive.getNewSkillInstance(compound.getByte("id"));
        skill.readFromNBT(compound);
        return skill;
    }
}

