/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.client.SyncSkillPacket;
import dynamicswordskills.skills.ArmorBreak;
import dynamicswordskills.skills.BackSlice;
import dynamicswordskills.skills.Dash;
import dynamicswordskills.skills.Dodge;
import dynamicswordskills.skills.EndingBlow;
import dynamicswordskills.skills.LeapingBlow;
import dynamicswordskills.skills.MortalDraw;
import dynamicswordskills.skills.Parry;
import dynamicswordskills.skills.RisingCut;
import dynamicswordskills.skills.SpinAttack;
import dynamicswordskills.skills.SwordBasic;
import dynamicswordskills.skills.SwordBeam;
import dynamicswordskills.skills.SwordBreak;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public abstract class SkillBase {
    public static final byte MAX_LEVEL = 5;
    private static byte skillIndex = 0;
    private static final Map<Byte, SkillBase> skillsMap = new HashMap<Byte, SkillBase>();
    private static final List<String> skillNames = new ArrayList<String>();
    public static final SkillBase swordBasic = new SwordBasic("swordbasic").addDescriptions(1);
    public static final SkillBase armorBreak = new ArmorBreak("armorbreak").addDescriptions(1);
    public static final SkillBase dodge = new Dodge("dodge").addDescriptions(1);
    public static final SkillBase leapingBlow = new LeapingBlow("leapingblow").addDescriptions(1);
    public static final SkillBase parry = new Parry("parry").addDescriptions(1);
    public static final SkillBase dash = new Dash("dash").addDescriptions(1);
    public static final SkillBase spinAttack = new SpinAttack("spinattack").addDescriptions(1);
    public static final SkillBase superSpinAttack = new SpinAttack("superspinattack").addDescriptions(1);
    public static final SkillBase mortalDraw = new MortalDraw("mortaldraw").addDescriptions(1);
    public static final SkillBase swordBreak = new SwordBreak("swordbreak").addDescriptions(1);
    public static final SkillBase risingCut = new RisingCut("risingcut").addDescriptions(1);
    public static final SkillBase endingBlow = new EndingBlow("endingblow").addDescriptions(1);
    public static final SkillBase backSlice = new BackSlice("backslice").addDescriptions(1);
    public static final SkillBase swordBeam = new SwordBeam("swordbeam").addDescriptions(1);
    private final String unlocalizedName;
    private final byte id;
    protected byte level = 0;
    private final List<String> tooltip = new ArrayList<String>();

    protected SkillBase(String name, boolean register) {
        this.unlocalizedName = name;
        byte by = skillIndex;
        skillIndex = (byte)(by + 1);
        this.id = by;
        if (register) {
            if (skillsMap.containsKey(this.id)) {
                DynamicSwordSkills.logger.warn("CONFLICT @ skill " + this.id + " id already occupied by " + SkillBase.skillsMap.get((Object)Byte.valueOf((byte)this.id)).unlocalizedName + " while adding " + name);
            }
            skillsMap.put(this.id, this);
            skillNames.add(this.unlocalizedName);
        }
    }

    protected SkillBase(SkillBase skill) {
        this.unlocalizedName = skill.unlocalizedName;
        this.id = skill.id;
        this.tooltip.addAll(skill.tooltip);
    }

    public static final boolean doesSkillExist(int id) {
        return id >= 0 && id <= 127 && skillsMap.containsKey((byte)id);
    }

    public static final SkillBase getNewSkillInstance(byte id) {
        return skillsMap.containsKey(id) ? skillsMap.get(id).newInstance() : null;
    }

    public static final SkillBase getSkill(int id) {
        return SkillBase.doesSkillExist(id) ? skillsMap.get((byte)id) : null;
    }

    public static final Collection<SkillBase> getSkills() {
        return Collections.unmodifiableCollection(skillsMap.values());
    }

    public static final int getNumSkills() {
        return skillsMap.size();
    }

    public static final String[] getSkillNames() {
        return skillNames.toArray(new String[skillNames.size()]);
    }

    public static final SkillBase getSkillByName(String name) {
        for (SkillBase skill : SkillBase.getSkills()) {
            if (!name.equals(skill.getUnlocalizedName())) continue;
            return skill;
        }
        return null;
    }

    public static final SkillBase getSkillFromItem(ItemStack stack, ISkillProvider item) {
        return SkillBase.createLeveledSkill(item.getSkillId(stack), item.getSkillLevel(stack));
    }

    public static final SkillBase createLeveledSkill(int id, byte level) {
        if (SkillBase.doesSkillExist(id) && level > 0) {
            SkillBase skill = SkillBase.getNewSkillInstance((byte)id);
            byte by = level > skill.getMaxLevel() ? skill.getMaxLevel() : level;
            skill.level = by;
            return skill;
        }
        return null;
    }

    public int hashCode() {
        return 31 * (31 + this.id) + this.level;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SkillBase skill = (SkillBase)obj;
        return skill.id == this.id && skill.level == this.level;
    }

    public abstract SkillBase newInstance();

    public final String getDisplayName() {
        return StatCollector.translateToLocal((String)(this.getFullUnlocalizedName() + ".name"));
    }

    public final String getTranslationString() {
        return this.getFullUnlocalizedName() + ".name";
    }

    public final String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public final String getFullUnlocalizedName() {
        return "skill.dss." + this.unlocalizedName;
    }

    public String getIconTexture() {
        return "dynamicswordskills:skillorb_" + this.unlocalizedName;
    }

    public final byte getId() {
        return this.id;
    }

    public final byte getLevel() {
        return this.level;
    }

    public byte getMaxLevel() {
        return 5;
    }

    protected final String getInfoString(String label, int n) {
        return this.getFullUnlocalizedName() + ".desc." + label + (n < 0 ? "" : "." + n);
    }

    protected final SkillBase addDescription(String string) {
        this.tooltip.add(string);
        return this;
    }

    protected final SkillBase addDescription(List<String> list) {
        for (String s : list) {
            this.tooltip.add(s);
        }
        return this;
    }

    protected final SkillBase addDescriptions(int n) {
        for (int i = 1; i <= n; ++i) {
            this.tooltip.add(this.getInfoString("tooltip", i));
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public final List<String> getTranslatedTooltip(EntityPlayer player) {
        ArrayList<String> desc = new ArrayList<String>(this.tooltip.size());
        for (String s : this.tooltip) {
            desc.add(StatCollector.translateToLocal((String)s));
        }
        if (Minecraft.getMinecraft().gameSettings.advancedItemTooltips) {
            this.addInformation(desc, player);
        }
        return desc;
    }

    @SideOnly(value=Side.CLIENT)
    public final List<String> getDescription() {
        ArrayList<String> desc = new ArrayList<String>(this.tooltip.size());
        for (String s : this.tooltip) {
            desc.add(StatCollector.translateToLocal((String)s));
        }
        return desc;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getDescription(EntityPlayer player) {
        List<String> desc = this.getDescription();
        this.addInformation(desc, player);
        return desc;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
    }

    public String getActivationDisplay() {
        return StatCollector.translateToLocal((String)(this.getFullUnlocalizedName() + ".desc.activate"));
    }

    public String getAreaDisplay(double area) {
        return StatCollector.translateToLocalFormatted((String)"skill.dss.desc.area", (Object[])new Object[]{String.format("%.1f", area)});
    }

    public String getChargeDisplay(int chargeTime) {
        return StatCollector.translateToLocalFormatted((String)"skill.dss.desc.charge", (Object[])new Object[]{chargeTime});
    }

    public String getDamageDisplay(float damage, boolean displayPlus) {
        return StatCollector.translateToLocalFormatted((String)"skill.dss.desc.damage", (Object[])new Object[]{displayPlus ? "+" : "", String.format("%.1f", Float.valueOf(damage))});
    }

    public String getDamageDisplay(int damage, boolean displayPlus) {
        return StatCollector.translateToLocalFormatted((String)"skill.dss.desc.damage", (Object[])new Object[]{displayPlus ? "+" : "", damage});
    }

    public String getDurationDisplay(int duration, boolean inTicks) {
        return StatCollector.translateToLocalFormatted((String)"skill.dss.desc.duration", (Object[])new Object[]{inTicks ? duration : duration / 20, inTicks ? StatCollector.translateToLocal((String)"skill.dss.ticks") : StatCollector.translateToLocal((String)"skill.dss.seconds")});
    }

    public String getExhaustionDisplay(float exhaustion) {
        return StatCollector.translateToLocalFormatted((String)"skill.dss.desc.exhaustion", (Object[])new Object[]{String.format("%.2f", Float.valueOf(exhaustion))});
    }

    public String getFullDescription() {
        return StatCollector.translateToLocal((String)(this.getFullUnlocalizedName() + ".desc.full"));
    }

    public String getLevelDisplay(boolean simpleMax) {
        return simpleMax && this.level == this.getMaxLevel() ? StatCollector.translateToLocal((String)"skill.dss.level.max") : StatCollector.translateToLocalFormatted((String)"skill.dss.desc.level", (Object[])new Object[]{this.level, this.getMaxLevel()});
    }

    public String getRangeDisplay(double range) {
        return StatCollector.translateToLocalFormatted((String)"skill.dss.desc.range", (Object[])new Object[]{String.format("%.1f", range)});
    }

    public String getTimeLimitDisplay(int time) {
        return StatCollector.translateToLocalFormatted((String)"skill.dss.desc.time", (Object[])new Object[]{time});
    }

    protected boolean canIncreaseLevel(EntityPlayer player, int targetLevel) {
        return this.level + 1 == targetLevel && targetLevel <= this.getMaxLevel();
    }

    protected abstract void levelUp(EntityPlayer var1);

    public void validateSkill(EntityPlayer player) {
        this.levelUp(player);
    }

    public final boolean grantSkill(EntityPlayer player) {
        return this.grantSkill(player, this.level + 1);
    }

    public final boolean grantSkill(EntityPlayer player, int targetLevel) {
        if (targetLevel <= this.level || targetLevel > this.getMaxLevel()) {
            return false;
        }
        byte oldLevel = this.level;
        while (this.level < targetLevel && this.canIncreaseLevel(player, this.level + 1)) {
            this.level = (byte)(this.level + 1);
            this.levelUp(player);
        }
        if (!player.worldObj.isRemote && oldLevel < this.level) {
            PacketDispatcher.sendTo(new SyncSkillPacket(this), (EntityPlayerMP)player);
        }
        return oldLevel < this.level;
    }

    public void onUpdate(EntityPlayer player) {
    }

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract SkillBase loadFromNBT(NBTTagCompound var1);
}

