/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.network.server.RefreshSpinPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SpinAttack
extends SkillActive {
    private int charge;
    private float currentSpin;
    private float arc;
    private int refreshed;
    @SideOnly(value=Side.CLIENT)
    private boolean clockwise;
    @SideOnly(value=Side.CLIENT)
    private boolean wasKeyPressed;
    @SideOnly(value=Side.CLIENT)
    private List<EntityLivingBase> targets;
    private boolean isFlaming;
    private int superLevel;

    public SpinAttack(String name) {
        super(name);
    }

    private SpinAttack(SpinAttack skill) {
        super(skill);
    }

    @Override
    public SpinAttack newInstance() {
        return new SpinAttack(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        byte temp = this.level;
        if (!this.isActive()) {
            this.superLevel = this.checkHealth(player) ? (int)DSSPlayerInfo.get(player).getSkillLevel(superSpinAttack) : 0;
            this.level = DSSPlayerInfo.get(player).getSkillLevel(spinAttack);
        }
        desc.add(this.getChargeDisplay(this.getChargeTime()));
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 1).replace("super", ""), (Object[])new Object[]{this.superLevel + 1}));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
        this.level = temp;
    }

    @Override
    public boolean isActive() {
        return this.arc > 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.isActive() && !this.isCharging();
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - 0.2f * (float)this.level;
    }

    private int getChargeTime() {
        return 20 - this.level * 2;
    }

    private boolean isCharging() {
        return this.charge > 0;
    }

    private boolean canRefresh() {
        return this.refreshed < this.superLevel + 1 && this.arc == 360.0f * (float)this.refreshed;
    }

    private float getRange() {
        return 3.0f + (float)(this.superLevel + this.level) * 0.5f;
    }

    private float getSpinSpeed() {
        return 70 + 3 * (this.superLevel + this.level);
    }

    private boolean checkHealth(EntityPlayer player) {
        return player.capabilities.isCreativeMode || PlayerUtils.getHealthMissing(player) <= Config.getHealthAllowance(this.level);
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isWeapon(player.getHeldItem());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return super.canUse(player) && PlayerUtils.isWeapon(player.getHeldItem());
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isKeyPressed() {
        return DSSKeyHandler.keys[3].getIsKeyPressed() || DSSKeyHandler.keys[4].getIsKeyPressed() || Config.allowVanillaControls() && Minecraft.getMinecraft().gameSettings.keyBindLeft.getIsKeyPressed() && Minecraft.getMinecraft().gameSettings.keyBindRight.getIsKeyPressed();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return Config.allowVanillaControls() && (key == mc.gameSettings.keyBindLeft || key == mc.gameSettings.keyBindRight) || key == DSSKeyHandler.keys[3] || key == DSSKeyHandler.keys[4];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == mc.gameSettings.keyBindAttack || key == DSSKeyHandler.keys[2]) {
            if (this.isActive() && this.canRefresh() && this.canExecute(player)) {
                PacketDispatcher.sendToServer(new RefreshSpinPacket());
                this.arc += 360.0f;
                return true;
            }
        } else if (!this.isCharging()) {
            if (this.wasKeyPressed) {
                this.wasKeyPressed = false;
            } else {
                this.clockwise = key == DSSKeyHandler.keys[4] || key == mc.gameSettings.keyBindRight;
                this.wasKeyPressed = true;
            }
            if (this.isKeyPressed()) {
                this.wasKeyPressed = false;
                this.charge = this.getChargeTime();
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.currentSpin = 0.0f;
        this.arc = 360.0f;
        this.refreshed = 0;
        this.superLevel = this.checkHealth(player) ? (int)DSSPlayerInfo.get(player).getSkillLevel(superSpinAttack) : 0;
        this.isFlaming = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)player) > 0;
        this.startSpin(world, player);
        return true;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.charge = 0;
        this.currentSpin = 0.0f;
        this.arc = 0.0f;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isCharging()) {
            if (PlayerUtils.isWeapon(player.getHeldItem()) && player.worldObj.isRemote && this.isKeyPressed()) {
                if (this.charge < this.getChargeTime() - 1) {
                    Minecraft.getMinecraft().playerController.sendUseItem(player, player.worldObj, player.getHeldItem());
                }
                --this.charge;
                if (this.charge == 0 && this.canExecute(player)) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                }
            } else {
                this.charge = 0;
            }
        } else if (this.isActive()) {
            this.incrementSpin(player);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        if (PlayerUtils.isWeapon(player.getHeldItem())) {
            List<EntityLivingBase> list = TargetUtils.acquireAllLookTargets((EntityLivingBase)player, (int)(this.getRange() + 0.5f), 1.0);
            for (EntityLivingBase target : list) {
                if (this.targets == null || !this.targets.contains(target)) continue;
                Minecraft.getMinecraft().playerController.attackEntity(player, (Entity)target);
                this.targets.remove(target);
            }
            this.spawnParticles(player);
            player.swingProgress = 0.5f;
            player.setAngles(this.clockwise ? this.getSpinSpeed() : -this.getSpinSpeed(), 0.0f);
        }
        return true;
    }

    private void startSpin(World world, EntityPlayer player) {
        ++this.refreshed;
        if (world.isRemote) {
            this.targets = world.getEntitiesWithinAABB(EntityLivingBase.class, player.boundingBox.expand((double)this.getRange(), 0.0, (double)this.getRange()));
            if (this.targets.contains(player)) {
                this.targets.remove(player);
            }
        } else {
            PlayerUtils.playRandomizedSound(player, "dynamicswordskills:spinattack", 0.4f, 0.5f);
            if (this.refreshed > 1) {
                player.addExhaustion(this.getExhaustion());
            }
        }
    }

    private void incrementSpin(EntityPlayer player) {
        this.currentSpin = (float)((double)this.currentSpin + (double)this.getSpinSpeed() * 0.24);
        if (this.currentSpin >= this.arc) {
            this.deactivate(player);
        } else if (this.currentSpin > 360.0f * (float)this.refreshed) {
            this.startSpin(player.worldObj, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EntityPlayer player) {
        String particle = this.isFlaming ? "flame" : (this.superLevel > 0 ? "magicCrit" : "crit");
        Vec3 vec3 = player.getLookVec();
        double posX = player.posX + vec3.xCoord * (double)this.getRange();
        double posY = player.posY + (double)player.getEyeHeight() - 0.1;
        double posZ = player.posZ + vec3.zCoord * (double)this.getRange();
        for (int i = 0; i < 2; ++i) {
            player.worldObj.spawnParticle(particle, posX, posY, posZ, vec3.xCoord * 0.15, 0.01, vec3.zCoord * 0.15);
        }
    }

    public void refreshServerSpin(EntityPlayer player) {
        if (this.canRefresh() && super.canUse(player) && PlayerUtils.isWeapon(player.getHeldItem())) {
            this.arc += 360.0f;
        }
    }
}

