/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.entity.EntitySwordBeam;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SwordBeam
extends SkillActive {
    private int missTimer;

    public SwordBeam(String name) {
        super(name);
    }

    private SwordBeam(SwordBeam skill) {
        super(skill);
    }

    @Override
    public SwordBeam newInstance() {
        return new SwordBeam(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.getDamageFactor(player), false) + "%");
        desc.add(this.getRangeDisplay(12 + this.level));
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 1), (Object[])new Object[]{String.format("%.1f", Float.valueOf(Config.getHealthAllowance(this.level) / 2.0f))}));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean hasAnimation() {
        return false;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    private boolean checkHealth(EntityPlayer player) {
        return player.capabilities.isCreativeMode || PlayerUtils.getHealthMissing(player) <= Config.getHealthAllowance(this.level);
    }

    private int getDamageFactor(EntityPlayer player) {
        return 30 + this.level * 10;
    }

    private float getDamage(EntityPlayer player) {
        return (float)((double)this.getDamageFactor(player) * 0.01 * player.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue());
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && this.checkHealth(player) && player.attackTime == 0 && PlayerUtils.isSwordOrProvider(player.getHeldItem(), this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.onGround && player.isSneaking() && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == DSSKeyHandler.keys[2] || Config.allowVanillaControls() && key == mc.gameSettings.keyBindAttack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        if (!world.isRemote) {
            this.missTimer = 12 + this.level;
            PlayerUtils.playSoundAtEntity(world, (Entity)player, "dynamicswordskills:whoosh", 0.4f, 0.5f);
            Vec3 vec3 = player.getLookVec();
            EntitySwordBeam beam = new EntitySwordBeam(world, (EntityLivingBase)player).setLevel(this.level).setDamage(this.getDamage(player));
            beam.setPosition(beam.posX + vec3.xCoord * 0.5, beam.posY + vec3.yCoord * 0.5, beam.posZ + vec3.zCoord * 0.5);
            world.spawnEntityInWorld((Entity)beam);
        } else {
            player.swingItem();
            player.attackTime = player.capabilities.isCreativeMode ? 0 : 20 - this.level;
        }
        return true;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.missTimer = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.missTimer > 0) {
            ICombo combo;
            --this.missTimer;
            if (this.missTimer == 0 && !player.worldObj.isRemote && (combo = DSSPlayerInfo.get(player).getComboSkill()) != null && combo.isComboInProgress()) {
                combo.getCombo().endCombo(player);
            }
        }
    }

    public void onImpact(EntityPlayer player, boolean hitBlock) {
        this.missTimer = hitBlock && this.missTimer > 0 ? 1 : 0;
    }
}

