/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.CommonProxy;
import dynamicswordskills.DSSCombatEvents;
import dynamicswordskills.api.ItemRandomSkill;
import dynamicswordskills.api.ItemSkillProvider;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.api.WeaponRegistry;
import dynamicswordskills.command.DSSCommands;
import dynamicswordskills.crafting.RecipeInfuseSkillOrb;
import dynamicswordskills.entity.EntityLeapingBlow;
import dynamicswordskills.entity.EntitySwordBeam;
import dynamicswordskills.item.ItemSkillOrb;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.Skills;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="dynamicswordskills", name="Dynamic Sword Skills", version="1.7.10-final", guiFactory="dynamicswordskills.client.gui.GuiFactoryConfig")
public class DynamicSwordSkills {
    @Mod.Instance(value="dynamicswordskills")
    public static DynamicSwordSkills instance;
    @SidedProxy(clientSide="dynamicswordskills.ClientProxy", serverSide="dynamicswordskills.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger logger;
    public static final float BASE_FPS = 30.0f;
    public static boolean isBG2Enabled;
    public static CreativeTabs tabSkills;
    public static Item skillOrb;
    public static List<Item> skillItems;
    public static Item skillWood;
    public static Item skillStone;
    public static Item skillGold;
    public static Item skillIron;
    public static Item skillDiamond;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (Loader.isModLoaded((String)"zeldaswordskills")) {
            throw new RuntimeException("Dynamic Sword Skills may not be loaded at the same time as Zelda Sword Skills! Please remove one or the other.");
        }
        isBG2Enabled = Loader.isModLoaded((String)"battlegear2");
        Skills.init();
        Config.init(event);
        tabSkills = new CreativeTabs("dss.skills"){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return skillOrb;
            }
        };
        skillOrb = new ItemSkillOrb(Skills.getSkillIdMap()).func_77655_b("dss.skillorb");
        GameRegistry.registerItem((Item)skillOrb, (String)"skillorb");
        if (Config.areCreativeSwordsEnabled()) {
            skillItems = new ArrayList<Item>(SkillRegistry.getValues().size());
            List<SkillBase> skills = SkillRegistry.getSortedList(SkillRegistry.SORT_BY_ID);
            for (SkillBase skill : skills) {
                if (!(skill instanceof SkillActive)) continue;
                int level = skill.getMaxLevel() == 5 ? Config.getSkillSwordLevel() : Config.getSkillSwordLevel() * 2;
                Item item = new ItemSkillProvider(Item.ToolMaterial.WOOD, skill, (byte)level).func_111206_d("stick").func_77655_b("dss.training_stick").func_77637_a(tabSkills);
                skillItems.add(item);
                GameRegistry.registerItem((Item)item, (String)("training_stick_" + skill.getRegistryName().func_110623_a()));
            }
        }
        if (Config.areRandomSwordsEnabled()) {
            skillWood = new ItemRandomSkill(Item.ToolMaterial.WOOD).func_111206_d("wood_sword").func_77655_b("dss.skill_sword.wood");
            GameRegistry.registerItem((Item)skillWood, (String)"skill_sword_wood");
            skillStone = new ItemRandomSkill(Item.ToolMaterial.STONE).func_111206_d("stone_sword").func_77655_b("dss.skill_sword.stone");
            GameRegistry.registerItem((Item)skillStone, (String)"skill_sword_stone");
            skillIron = new ItemRandomSkill(Item.ToolMaterial.IRON).func_111206_d("iron_sword").func_77655_b("dss.skill_sword.iron");
            GameRegistry.registerItem((Item)skillIron, (String)"skill_sword_iron");
            skillGold = new ItemRandomSkill(Item.ToolMaterial.GOLD).func_111206_d("gold_sword").func_77655_b("dss.skill_sword.gold");
            GameRegistry.registerItem((Item)skillGold, (String)"skill_sword_gold");
            skillDiamond = new ItemRandomSkill(Item.ToolMaterial.EMERALD).func_111206_d("diamond_sword").func_77655_b("dss.skill_sword.diamond");
            GameRegistry.registerItem((Item)skillDiamond, (String)"skill_sword_diamond");
        }
        EntityRegistry.registerModEntity(EntityLeapingBlow.class, (String)"leapingblow", (int)0, (Object)this, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntitySwordBeam.class, (String)"swordbeam", (int)1, (Object)this, (int)64, (int)10, (boolean)true);
        PacketDispatcher.initialize();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
        DSSCombatEvents events = new DSSCombatEvents();
        MinecraftForge.EVENT_BUS.register((Object)events);
        FMLCommonHandler.instance().bus().register((Object)events);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        String link = "https://raw.githubusercontent.com/coolAlias/DynamicSwordSkills/master/src/main/resources/versionlist.json";
        FMLInterModComms.sendRuntimeMessage((Object)"dynamicswordskills", (String)"VersionChecker", (String)"addVersionCheck", (String)link);
        GameRegistry.addRecipe((IRecipe)new RecipeInfuseSkillOrb());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Config.postInit();
        DSSCombatEvents.initializeDrops();
        if (Config.getOrbLootWeight() > 0) {
            this.registerSkillOrbLoot();
        }
        if (Config.areRandomSwordsEnabled() && Config.getSkillSwordLootWeight() > 0) {
            this.registerRandomSwordLoot();
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        DSSCommands.registerCommands(event);
    }

    @Mod.EventHandler
    public void processMessages(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            WeaponRegistry.INSTANCE.processMessage(msg);
        }
    }

    @Mod.EventHandler
    public void processMissingMappings(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            SkillBase skill;
            String s = mapping.name.replace("dynamicswordskills:", "");
            String location = null;
            if (s.matches("^dss.skillitem([0-9])+$")) {
                int i = Integer.valueOf(s.replace("dss.skillitem", ""));
                skill = SkillRegistry.getSkillById(i);
                if (Skills.superSpinAttack.is(skill)) {
                    mapping.ignore();
                } else if (skill != null) {
                    location = "training_stick_" + skill.getRegistryName().func_110623_a().toLowerCase();
                }
            } else if (s.startsWith("training_stick_")) {
                String skill_name = s.substring("training_stick_".length());
                skill = SkillRegistry.get(new ResourceLocation("dynamicswordskills", skill_name));
                if (Skills.superSpinAttack.is(skill)) {
                    mapping.ignore();
                } else if (skill != null && !skill.getRegistryName().func_110623_a().equals(skill_name)) {
                    location = "training_stick_" + skill.getRegistryName().func_110623_a().toLowerCase();
                }
            } else if (s.matches("^dss.skill(wood|stone|iron|diamond|gold)$")) {
                location = s.replace("dss.skill", "skill_sword_").toLowerCase();
            } else if (s.startsWith("dss.")) {
                location = s.replace("dss.", "").toLowerCase();
            }
            if (location == null) continue;
            Item item = GameRegistry.findItem((String)"dynamicswordskills", (String)location);
            if (item == null) {
                mapping.fail();
                continue;
            }
            mapping.remap(item);
        }
    }

    private void registerSkillOrbLoot() {
        for (ResourceLocation location : Skills.getSkillIdMap().values()) {
            SkillBase skill = SkillRegistry.get(location);
            if (!Config.isSkillAllowed(skill)) continue;
            this.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillOrb, 1, (int)skill.getId()), 1, 1, Config.getOrbLootWeight()), false);
        }
    }

    private void registerRandomSwordLoot() {
        this.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillWood), 1, 1, Config.getSkillSwordLootWeight() * 2), false);
        this.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillStone), 1, 1, Config.getSkillSwordLootWeight()), false);
        this.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillGold), 1, 1, Config.getSkillSwordLootWeight()), false);
        this.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillIron), 1, 1, Config.getSkillSwordLootWeight() * 2), false);
        this.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillDiamond), 1, 1, Config.getSkillSwordLootWeight()), false);
    }

    private void addLootToAll(WeightedRandomChestContent loot, boolean bonus) {
        ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(loot);
        ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(loot);
        ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdCorridor").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdLibrary").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdCrossing").addItem(loot);
        ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(loot);
        ChestGenHooks.getInfo((String)"dungeonChest").addItem(loot);
        if (bonus) {
            ChestGenHooks.getInfo((String)"bonusChest").addItem(loot);
        }
    }

    public static ResourceLocation getResourceLocation(String name) {
        try {
            return new ResourceLocation(name);
        }
        catch (NullPointerException e) {
            logger.error(String.format("Invalid ResourceLocation string: %s", name));
            return null;
        }
    }

    static {
        logger = LogManager.getLogger((String)"dynamicswordskills");
    }
}

