/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.api;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.Skills;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSkillProvider
extends Item
implements ISkillProvider {
    private final Item.ToolMaterial material;
    private float weaponDamage;
    private final ResourceLocation skillName;
    private final byte level;
    private SkillBase skill;
    private final boolean grantsBasicSkill;

    public ItemSkillProvider(Item.ToolMaterial material, SkillBase skill, byte level) {
        this(material, skill, level, true);
    }

    public ItemSkillProvider(Item.ToolMaterial material, SkillBase skill, byte level, boolean grantsBasicSkill) {
        this.material = material;
        this.weaponDamage = 2.0f + this.material.func_78000_c();
        this.skillName = skill.getRegistryName();
        this.level = level;
        this.grantsBasicSkill = grantsBasicSkill;
        this.func_77656_e(this.material.func_77997_a());
        this.func_77625_d(1);
    }

    @Override
    public boolean isSword(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isWeapon(ItemStack stack) {
        return true;
    }

    protected SkillBase getSkill(ItemStack stack) {
        if (this.skill == null) {
            this.skill = SkillBase.getSkillFromItem(stack, this);
        }
        return this.skill;
    }

    @Override
    public int getSkillId(ItemStack stack) {
        SkillBase skill = SkillRegistry.get(this.skillName);
        return skill == null ? -1 : (int)skill.getId();
    }

    @Override
    public byte getSkillLevel(ItemStack stack) {
        return this.level;
    }

    @Override
    public boolean grantsBasicSwordSkill(ItemStack stack) {
        return this.grantsBasicSkill;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack stack) {
        return this.material.func_150995_f() == stack.func_77973_b() ? true : super.func_82789_a(toRepair, stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            stack.func_77972_a(2, entity);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public String func_77653_i(ItemStack stack) {
        SkillBase skill = this.getSkill(stack);
        return StatCollector.func_74837_a((String)(this.func_77667_c(stack) + ".name"), (Object[])new Object[]{skill == null ? "" : skill.getDisplayName()});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        SkillBase skill = this.getSkill(stack);
        if (skill != null) {
            list.add(StatCollector.func_74837_a((String)"tooltip.dss.skill_provider.desc.skill", (Object[])new Object[]{skill.getLevel(), EnumChatFormatting.GOLD + skill.getDisplayName() + EnumChatFormatting.GRAY}));
            if (this.grantsBasicSwordSkill(stack)) {
                String name = EnumChatFormatting.DARK_GREEN + Skills.swordBasic.getDisplayName() + EnumChatFormatting.GRAY;
                list.add(StatCollector.func_74837_a((String)"tooltip.dss.skill_provider.desc.provider", (Object[])new Object[]{name}));
            }
            if (advanced) {
                list.addAll(skill.getTooltip(player, true));
            }
        }
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.weaponDamage, 0));
        return multimap;
    }
}

