/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.skills.SkillBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class SkillRegistry {
    private static final Map<ResourceLocation, SkillBase> map = new HashMap<ResourceLocation, SkillBase>();
    private static final Map<ResourceLocation, ResourceLocation> remap = new HashMap<ResourceLocation, ResourceLocation>();
    private static final BiMap<ResourceLocation, Integer> ids = HashBiMap.create();
    private static int index = 0;
    public static final Comparator<SkillBase> SORT_BY_ID = new Comparator<SkillBase>(){

        @Override
        public int compare(SkillBase a, SkillBase b) {
            return a.getId() - b.getId();
        }
    };
    public static final Comparator<SkillBase> SORT_BY_REGISTRY_NAME = new Comparator<SkillBase>(){

        @Override
        public int compare(SkillBase a, SkillBase b) {
            return a.getRegistryName().toString().compareTo(b.getRegistryName().toString());
        }
    };

    public static SkillBase register(SkillBase skill) {
        Preconditions.checkArgument((skill != null ? 1 : 0) != 0, (Object)"Skill instance can not be null");
        Preconditions.checkArgument((skill.getRegistryName() != null ? 1 : 0) != 0, (Object)String.format("Registry name can not be null for %s", skill.getTranslationKey()));
        if (map.containsKey(skill.getRegistryName())) {
            DynamicSwordSkills.logger.error(String.format("Registry name %s is already in use by %s", skill.getRegistryName().toString(), map.get(skill.getRegistryName()).getTranslationKey()));
            return map.get(skill.getRegistryName());
        }
        map.put(skill.getRegistryName(), skill);
        ids.put((Object)skill.getRegistryName(), (Object)index);
        ++index;
        return skill.onRegistered();
    }

    public static void remap(ResourceLocation _old, ResourceLocation _new) {
        Preconditions.checkArgument((boolean)_old.func_110624_b().equals(_new.func_110624_b()), (Object)String.format("Remapping entries must have the same resource domain! Old: %s | New: %s", _old.func_110624_b(), _new.func_110624_b()));
        Preconditions.checkArgument((!remap.containsKey(_old) ? 1 : 0) != 0, (Object)String.format("A remapping entry already exists for %s", _old.func_110624_b()));
        remap.put(_old, _new);
    }

    public static SkillBase get(ResourceLocation location) {
        SkillBase skill = map.get(location);
        if (skill == null) {
            skill = map.get(remap.get(location));
        }
        return skill;
    }

    public static Set<ResourceLocation> getKeys() {
        return Collections.unmodifiableSet(map.keySet());
    }

    public static Collection<SkillBase> getValues() {
        return Collections.unmodifiableCollection(map.values());
    }

    public static List<SkillBase> getSortedList(Comparator<SkillBase> sort) {
        ArrayList skills = Lists.newArrayList(map.values());
        Collections.sort(skills, sort);
        return Collections.unmodifiableList(skills);
    }

    public static int getSkillId(SkillBase skill) {
        Integer id = (Integer)ids.get((Object)skill.getRegistryName());
        if (id == null) {
            id = (Integer)ids.get((Object)remap.get(skill.getRegistryName()));
        }
        return id == null ? -1 : id;
    }

    public static SkillBase getSkillById(int id) {
        return SkillRegistry.get((ResourceLocation)ids.inverse().get((Object)id));
    }
}

