/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DSSCombatEvents;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.client.gui.ComboOverlay;
import dynamicswordskills.client.gui.GuiEndingBlowOverlay;
import dynamicswordskills.client.gui.IGuiOverlay;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.server.ReachAttackSkillPacket;
import dynamicswordskills.skills.IComboSkill;
import dynamicswordskills.skills.SkillBase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

@SideOnly(value=Side.CLIENT)
public class DSSClientEvents {
    private final Minecraft mc;
    private final List<IGuiOverlay> overlays = new ArrayList<IGuiOverlay>();
    private final List<IGuiOverlay> rendered = new ArrayList<IGuiOverlay>();
    private static Field debugFPS;

    public static int getDebugFPS() {
        if (debugFPS == null) {
            debugFPS = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"field_71470_ab", "debugFPS"});
        }
        try {
            return debugFPS.getInt(Minecraft.func_71410_x());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 30;
        }
    }

    public DSSClientEvents() {
        this.mc = Minecraft.func_71410_x();
        this.overlays.add(new ComboOverlay(this.mc));
        this.overlays.add(new GuiEndingBlowOverlay(this.mc));
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        for (IGuiOverlay overlay : this.overlays) {
            if (!overlay.shouldRender() || !overlay.renderOverlay(event.resolution, this.rendered)) continue;
            this.rendered.add(overlay);
        }
        this.rendered.clear();
    }

    public static void handlePlayerAttack(Minecraft mc) {
        if (mc.field_71439_g.func_71039_bw()) {
            return;
        }
        if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            mc.field_71442_b.func_78764_a((EntityPlayer)mc.field_71439_g, mc.field_71476_x.field_72308_g);
        } else {
            DSSClientEvents.handlePlayerMiss(mc);
        }
        mc.field_71439_g.func_71038_i();
        DSSCombatEvents.setPlayerAttackTime((EntityPlayer)mc.field_71439_g);
    }

    public static void handlePlayerMiss(Minecraft mc) {
        IComboSkill combo = DSSPlayerInfo.get((EntityPlayer)mc.field_71439_g).getComboSkill();
        if (combo != null) {
            combo.onMiss((EntityPlayer)mc.field_71439_g);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static <T extends SkillBase> void attackEntity(Minecraft mc, Entity target, T skill) {
        DirtyEntityAccessor.syncCurrentPlayItem(mc.field_71442_b);
        DSSClientEvents.multiAttack(mc, target, skill);
    }

    @SideOnly(value=Side.CLIENT)
    public static <T extends SkillBase> void multiAttack(Minecraft mc, Entity target, T skill) {
        PacketDispatcher.sendToServer(new ReachAttackSkillPacket(skill, target));
        mc.field_71439_g.func_71059_n(target);
    }

    @SubscribeEvent
    public void onMouseChanged(MouseEvent event) {
        if (event.button == -1 && event.dwheel == 0) {
            return;
        }
        if (event.dwheel != 0) {
            event.setCanceled(!DSSPlayerInfo.get((EntityPlayer)this.mc.field_71439_g).canInteract());
        } else {
            int mouseKey = event.button - 100;
            if (event.buttonstate) {
                event.setCanceled(DSSKeyHandler.onKeyPressed(this.mc, mouseKey));
            } else {
                DSSKeyHandler.onKeyReleased(this.mc, mouseKey);
            }
        }
    }
}

