/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.client.DSSClientEvents;
import dynamicswordskills.client.KeyBindingHolder;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class DSSKeyHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    public static final byte KEY_SKILL_ACTIVATE = 0;
    public static final byte KEY_NEXT_TARGET = 1;
    public static final byte KEY_SKILLS_GUI = 2;
    public static final byte KEY_FORWARD = 3;
    public static final byte KEY_BACK = 4;
    public static final byte KEY_LEFT = 5;
    public static final byte KEY_RIGHT = 6;
    private static final String[] desc = new String[]{"activate", "next", "skills_gui", "forward", "back", "left", "right"};
    private static final int[] keyValues = new int[]{45, 15, 25, 200, 208, 203, 205};
    public static final KeyBindingHolder[] keys = new KeyBindingHolder[desc.length];

    public DSSKeyHandler() {
        for (int i = 0; i < desc.length; ++i) {
            KeyBinding key = null;
            if (Config.enableAdditionalControls() || i < 3) {
                key = new KeyBinding("key.dss." + desc[i] + ".desc", keyValues[i], StatCollector.func_74838_a((String)"key.dss.label"));
                ClientRegistry.registerKeyBinding((KeyBinding)key);
            }
            DSSKeyHandler.keys[i] = new KeyBindingHolder(key);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (Keyboard.getEventKeyState()) {
            if (!Keyboard.isRepeatEvent()) {
                DSSKeyHandler.onKeyPressed(this.mc, Keyboard.getEventKey());
            }
        } else {
            DSSKeyHandler.onKeyReleased(this.mc, Keyboard.getEventKey());
        }
    }

    public static boolean onKeyPressed(Minecraft mc, int kb) {
        if (mc.field_71415_G && mc.field_71439_g != null) {
            if (kb == keys[2].getKeyCode()) {
                mc.field_71439_g.openGui((Object)DynamicSwordSkills.instance, 0, mc.field_71439_g.field_70170_p, (int)mc.field_71439_g.field_70165_t, (int)mc.field_71439_g.field_70163_u, (int)mc.field_71439_g.field_70161_v);
            } else {
                return DSSKeyHandler.handleSkillKeys(mc, kb);
            }
        }
        return false;
    }

    public static void onKeyReleased(Minecraft mc, int kb) {
        KeyBinding key = DSSKeyHandler.getKeyBindFromCode(mc, kb);
        if (key != null && mc.field_71415_G && mc.field_71439_g != null) {
            DSSPlayerInfo.get((EntityPlayer)mc.field_71439_g).onKeyReleased(mc, key);
        }
    }

    private static boolean handleSkillKeys(Minecraft mc, int kb) {
        boolean isLockedOn;
        DSSPlayerInfo skills = DSSPlayerInfo.get((EntityPlayer)mc.field_71439_g);
        ILockOnTarget lock = skills.getTargetingSkill();
        boolean canInteract = skills.canInteract();
        boolean bl = isLockedOn = lock != null && lock.isLockedOn();
        if (kb == keys[0].getKeyCode()) {
            if (lock instanceof SkillActive && ((SkillActive)((Object)lock)).isActive()) {
                skills.deactivateTargetingSkill();
            } else {
                skills.activateTargetingSkill();
            }
        } else if (kb == keys[1].getKeyCode()) {
            if (isLockedOn) {
                lock.getNextTarget((EntityPlayer)mc.field_71439_g);
            }
        } else {
            if (kb == mc.field_71474_y.field_74312_F.func_151463_i()) {
                if (!skills.canAttack()) {
                    return true;
                }
                if (!canInteract) {
                    skills.onKeyPressedWhileAnimating(mc, mc.field_71474_y.field_74312_F);
                    return true;
                }
                if (skills.onKeyPressed(mc, mc.field_71474_y.field_74312_F)) {
                    return true;
                }
                KeyBinding.func_74510_a((int)kb, (boolean)true);
                if (isLockedOn) {
                    DSSClientEvents.handlePlayerAttack(mc);
                } else if (mc.field_71476_x == null || mc.field_71476_x.field_72313_a != MovingObjectPosition.MovingObjectType.ENTITY) {
                    DSSClientEvents.handlePlayerMiss(mc);
                }
                return isLockedOn;
            }
            KeyBinding key = DSSKeyHandler.getKeyBindFromCode(mc, kb);
            if (key != null) {
                if (!canInteract) {
                    if (skills.canUseItem() || kb != mc.field_71474_y.field_74313_G.func_151463_i()) {
                        skills.onKeyPressedWhileAnimating(mc, key);
                    }
                    return true;
                }
                if (skills.onKeyPressed(mc, key)) {
                    return true;
                }
                KeyBinding.func_74510_a((int)kb, (boolean)true);
            }
        }
        return false;
    }

    public static KeyBinding getKeyBindFromCode(Minecraft mc, int keyCode) {
        for (KeyBinding k : mc.field_71474_y.field_74324_K) {
            if (k.func_151463_i() != keyCode) continue;
            if (!Config.allowVanillaControls() && DSSKeyHandler.isVanillaControl(mc, k)) {
                return null;
            }
            return k;
        }
        return null;
    }

    public static boolean isVanillaControl(Minecraft mc, KeyBinding key) {
        return key == mc.field_71474_y.field_74370_x || key == mc.field_71474_y.field_74366_z || key == mc.field_71474_y.field_74351_w || key == mc.field_71474_y.field_74368_y;
    }
}

