/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.gui.IGuiOverlay;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractGuiOverlay
extends Gui
implements IGuiOverlay {
    protected static final int DEFAULT_PADDING = 2;
    protected final Minecraft mc;
    protected int maxH;
    protected int maxW;
    protected int x;
    protected int y;
    protected int width;
    protected int height;

    public AbstractGuiOverlay(Minecraft mc) {
        this.mc = mc;
    }

    @Override
    public int getLeft() {
        return this.x;
    }

    @Override
    public int getRight() {
        return this.x + this.getWidth();
    }

    @Override
    public int getTop() {
        return this.y;
    }

    @Override
    public int getBottom() {
        return this.y + this.getHeight();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public IGuiOverlay.HALIGN getHorizontalAlignment() {
        return IGuiOverlay.HALIGN.LEFT;
    }

    @Override
    public IGuiOverlay.VALIGN getVerticalAlignment() {
        return IGuiOverlay.VALIGN.TOP;
    }

    @Override
    public boolean allowMergeX(boolean rendered) {
        return true;
    }

    @Override
    public boolean renderOverlay(ScaledResolution resolution, List<IGuiOverlay> overlays) {
        this.maxW = resolution.func_78326_a() / 3;
        this.maxH = resolution.func_78328_b() / 2;
        this.setup(resolution);
        for (IGuiOverlay overlay : overlays) {
            if (!this.intersectsWith(overlay) || this.coalesce(overlay, resolution)) continue;
            return false;
        }
        this.render(resolution);
        return true;
    }

    protected abstract void setup(ScaledResolution var1);

    protected abstract void render(ScaledResolution var1);

    protected int getOffsetX(int offset) {
        return this.getHorizontalAlignment().getOffset(offset);
    }

    protected int getOffsetY(int offset) {
        return this.getVerticalAlignment().getOffset(offset);
    }

    protected void setPosX(ScaledResolution resolution, int offset) {
        switch (this.getHorizontalAlignment()) {
            case LEFT: {
                this.x = offset;
                break;
            }
            case CENTER: {
                this.x = resolution.func_78326_a() / 2 - this.getWidth() / 2 + offset;
                break;
            }
            case RIGHT: {
                this.x = resolution.func_78326_a() - this.getWidth() + offset;
            }
        }
    }

    protected void setPosY(ScaledResolution resolution, int offset) {
        switch (this.getVerticalAlignment()) {
            case TOP: {
                this.y = offset;
                break;
            }
            case CENTER: {
                this.y = resolution.func_78328_b() / 2 - this.getHeight() / 2 + offset;
                break;
            }
            case BOTTOM: {
                this.y = resolution.func_78328_b() - this.getHeight() + offset;
            }
        }
    }

    public boolean intersectsWith(IGuiOverlay overlay) {
        return this.overlapsX(overlay) && this.overlapsY(overlay);
    }

    public boolean overlapsX(IGuiOverlay overlay) {
        return this.getLeft() <= overlay.getRight() && this.getRight() >= overlay.getLeft();
    }

    public boolean overlapsY(IGuiOverlay overlay) {
        return this.getTop() <= overlay.getBottom() && this.getBottom() >= overlay.getTop();
    }

    public boolean canCombineX(IGuiOverlay overlay) {
        if (!this.allowMergeX(false) || !overlay.allowMergeX(true)) {
            return false;
        }
        if (this.getHorizontalAlignment() != overlay.getHorizontalAlignment()) {
            return false;
        }
        if (!this.compareHeight(overlay)) {
            return false;
        }
        switch (this.getHorizontalAlignment()) {
            case LEFT: {
                return overlay.getRight() + this.getWidth() + 2 < this.maxW;
            }
            case CENTER: {
                return overlay.getRight() + this.getWidth() + 2 < this.maxW * 2;
            }
            case RIGHT: {
                return overlay.getLeft() - this.getWidth() - 2 > this.maxW * 2;
            }
        }
        return false;
    }

    protected boolean compareHeight(IGuiOverlay overlay) {
        return this.getHeight() <= overlay.getHeight();
    }

    protected boolean coalesce(IGuiOverlay overlay, ScaledResolution resolution) {
        if (this.canCombineX(overlay)) {
            if (!this.shiftX(overlay, resolution)) {
                return this.shiftY(overlay, resolution);
            }
        } else if (!this.shiftY(overlay, resolution)) {
            return this.shiftX(overlay, resolution);
        }
        return true;
    }

    protected boolean shiftX(IGuiOverlay overlay, ScaledResolution resolution) {
        switch (this.getHorizontalAlignment()) {
            case LEFT: 
            case CENTER: {
                if (overlay.getRight() + this.getWidth() + 2 > resolution.func_78326_a()) {
                    return false;
                }
                this.x = overlay.getRight() + 2;
                break;
            }
            case RIGHT: {
                if (overlay.getLeft() - (this.getWidth() + 2) < 0) {
                    return false;
                }
                this.x = overlay.getLeft() - (this.getWidth() + 2);
            }
        }
        return true;
    }

    protected boolean shiftY(IGuiOverlay overlay, ScaledResolution resolution) {
        switch (this.getVerticalAlignment()) {
            case TOP: 
            case CENTER: {
                if (overlay.getBottom() + this.getHeight() + 2 > this.maxH * 2) {
                    return false;
                }
                this.y = overlay.getBottom() + 2;
                break;
            }
            case BOTTOM: {
                if (overlay.getTop() - (this.getHeight() + 2) < 0) {
                    return false;
                }
                this.y = overlay.getTop() - (this.getHeight() + 2);
            }
        }
        return true;
    }
}

