/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.gui.ButtonTextElement;
import dynamicswordskills.client.gui.GuiButtonCustom;
import dynamicswordskills.client.gui.GuiElementContainer;
import dynamicswordskills.client.gui.GuiTextElement;
import dynamicswordskills.client.gui.IGuiContainedElement;
import dynamicswordskills.client.gui.Padding;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

@SideOnly(value=Side.CLIENT)
public class GuiContainedButton
extends GuiButtonCustom
implements IGuiContainedElement {
    protected Padding padding = new Padding(0);
    protected final GuiTextElement labelElement;
    protected int remainingHeight;
    protected int remainingWidth;
    protected int scrollX;
    protected int scrollY;

    public GuiContainedButton(int id, int x, int y, int width, int height, String label) {
        this(id, x, y, width, height, label, true, false);
    }

    public GuiContainedButton(int id, int x, int y, int width, int height, String label, boolean drawLabelShadow, boolean isUnicode) {
        super(id, x, y, width, height, label, drawLabelShadow, isUnicode);
        this.labelElement = this.getButtonTextElement(label);
    }

    protected GuiTextElement getButtonTextElement(String label) {
        return new ButtonTextElement(this, (IChatComponent)new ChatComponentText(label));
    }

    @Override
    public Padding getPadding() {
        return this.padding;
    }

    public GuiContainedButton pad(int amount) {
        this.padding = new Padding(amount);
        return this;
    }

    public GuiContainedButton pad(int x, int y) {
        this.padding = new Padding(x, y);
        return this;
    }

    public GuiContainedButton pad(int top, int right, int bottom, int left) {
        this.padding = new Padding(top, right, bottom, left);
        return this;
    }

    @Override
    public boolean isElementExcluded() {
        return false;
    }

    @Override
    public int getContentHeight() {
        return this.field_146121_g;
    }

    @Override
    public int getContentWidth() {
        return this.field_146120_f;
    }

    @Override
    public int getDisplayedHeight() {
        return this.getContentHeight() - this.scrollY;
    }

    @Override
    public int getDisplayedWidth() {
        return this.getContentWidth() - this.scrollX;
    }

    @Override
    public int getElementPosX() {
        return this.field_146128_h;
    }

    @Override
    public int getElementPosY() {
        return this.field_146129_i;
    }

    @Override
    public void setElementPosition(int xPos, int yPos) {
        this.field_146128_h = xPos;
        this.field_146129_i = yPos;
        this.buttonElement.setElementPosition(xPos, yPos);
        this.labelElement.setElementPosition(xPos, yPos);
    }

    @Override
    public boolean setRemainingDisplayArea(int width, int height) {
        this.remainingHeight = height;
        this.remainingWidth = width;
        this.buttonElement.setRemainingDisplayArea(width, height);
        this.labelElement.setRemainingDisplayArea(width, height);
        return true;
    }

    @Override
    public void setScrolledAmount(int scrollX, int scrollY) {
        this.scrollX = Math.max(0, scrollX);
        this.scrollY = Math.max(0, scrollY);
        this.buttonElement.setScrolledAmount(scrollX, scrollY);
        this.labelElement.setScrolledAmount(scrollX, scrollY);
    }

    @Override
    public void setScrollableArea(int width, int height) {
        this.field_146124_l = false;
        this.field_146125_m = false;
    }

    @Override
    public void drawElement(Minecraft mc, int mouseX, int mouseY) {
        super.func_146112_a(mc, mouseX, mouseY);
    }

    @Override
    protected void drawLabelText(Minecraft mc, int mouseX, int mouseY) {
        if (this.drawLabelText) {
            this.labelElement.drawElement(mc, mouseX, mouseY);
        }
    }

    public boolean canEnableDisplayedPortion() {
        int dy = this.field_146121_g / 2 - 4 - 1;
        return this.scrollY < 1 && this.remainingHeight - dy > 8;
    }

    public static class GuiButtonContainer
    extends GuiElementContainer<GuiContainedButton> {
        protected final int guiLeft;
        protected final int guiTop;

        public GuiButtonContainer(int xPos, int yPos, int width, int height, int lineHeight, int guiLeft, int guiTop) {
            super(xPos, yPos, width, height);
            this.lineHeight = lineHeight;
            this.guiLeft = guiLeft;
            this.guiTop = guiTop;
        }

        @Override
        public int getScrollableWheelSpeed(boolean isHorizontal) {
            return this.lineHeight + this.elementPadY;
        }

        @Override
        protected void drawElement(GuiContainedButton button, Minecraft mc, int mouseX, int mouseY) {
            button.field_146129_i += this.guiTop;
            button.field_146124_l = button.canEnableDisplayedPortion();
            button.field_146125_m = true;
        }
    }
}

