/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.gui.IGuiElement;
import dynamicswordskills.client.gui.Padding;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiElement
extends Gui
implements IGuiElement {
    public int xPos;
    public int yPos;
    public final int width;
    public final int height;
    protected Padding padding = new Padding(0);

    public GuiElement(int xPos, int yPos, int width, int height) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.width = width;
        this.height = height;
    }

    @Override
    public Padding getPadding() {
        return this.padding;
    }

    public GuiElement pad(int amount) {
        this.padding = new Padding(amount);
        return this;
    }

    public GuiElement pad(int x, int y) {
        this.padding = new Padding(x, y);
        return this;
    }

    public GuiElement pad(int top, int right, int bottom, int left) {
        this.padding = new Padding(top, right, bottom, left);
        return this;
    }

    public void drawHoveredGradient(int gradientColorTop, int gradientColorBot) {
        this.drawHoveredGradient(gradientColorTop, gradientColorBot, 0);
    }

    public void drawHoveredGradient(int gradientColorTop, int gradientColorBot, int padding) {
        this.drawHoveredGradient(gradientColorTop, gradientColorBot, padding, padding);
    }

    public void drawHoveredGradient(int gradientColorTop, int gradientColorBot, int padX, int padY) {
        this.drawHoveredGradient(gradientColorTop, gradientColorBot, this.xPos + padX, this.yPos + padY, this.xPos + this.width - padX, this.yPos + this.height - padY);
    }

    public void drawHoveredGradient(int gradientColorTop, int gradientColorBot, Padding pad) {
        this.drawHoveredGradient(gradientColorTop, gradientColorBot, this.xPos + pad.left, this.yPos + pad.top, this.xPos + this.width - pad.right, this.yPos + this.height - pad.bottom);
    }

    public void drawHoveredGradient(int gradientColorTop, int gradientColorBot, int x1, int y1, int x2, int y2) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.func_73733_a(x1, y1, x2, y2, gradientColorTop, gradientColorBot);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glPopAttrib();
    }

    public boolean isMouseOverElement(int mouseX, int mouseY) {
        return this.isMouseOverElement(mouseX, mouseY, 0, 0);
    }

    public boolean isMouseOverElement(int mouseX, int mouseY, int borderX, int borderY) {
        return this.isMouseOverElement(mouseX, mouseY, this.xPos + borderX, this.xPos + this.width - borderX, this.yPos + borderY, this.yPos + this.height - borderY);
    }

    public boolean isMouseOverElement(int mouseX, int mouseY, int x1, int x2, int y1, int y2) {
        return mouseX >= x1 && mouseX < x2 && mouseY >= y1 && mouseY < y2;
    }

    public static class GuiCompositeElement
    extends GuiElement {
        protected final List<IGuiElement> components;

        public GuiCompositeElement(int xPos, int yPos, int width, int height, IGuiElement ... components) {
            super(xPos, yPos, width, height);
            this.components = components == null ? Lists.newArrayList() : Lists.newArrayList((Object[])components);
        }

        @Override
        public void drawElement(Minecraft mc, int mouseX, int mouseY) {
            for (IGuiElement e : this.components) {
                e.drawElement(mc, mouseX, mouseY);
            }
        }
    }
}

