/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.RenderHelperQ;
import dynamicswordskills.client.gui.AbstractGuiOverlay;
import dynamicswordskills.client.gui.IGuiOverlay;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.EndingBlow;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.Skills;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiEndingBlowOverlay
extends AbstractGuiOverlay {
    private long displayStartTime;
    private static final ResourceLocation HUD_ICONS = new ResourceLocation("dynamicswordskills", "textures/gui/hud_icons.png");
    private static final int ICON_SIZE = 16;
    private int iconIndex;
    private String text;

    public GuiEndingBlowOverlay(Minecraft mc) {
        super(mc);
    }

    @Override
    public IGuiOverlay.HALIGN getHorizontalAlignment() {
        return Config.endingBlowHudXAlign;
    }

    @Override
    public IGuiOverlay.VALIGN getVerticalAlignment() {
        return Config.endingBlowHudYAlign;
    }

    @Override
    public boolean shouldRender() {
        if (Config.isSkillDisabled((EntityPlayer)this.mc.field_71439_g, Skills.endingBlow) || Config.endingBlowHudDisplayTime < 1) {
            return false;
        }
        SkillActive skill = DSSPlayerInfo.get((EntityPlayer)this.mc.field_71439_g).getActiveSkill(Skills.endingBlow);
        if (skill == null) {
            this.displayStartTime = 0L;
        } else if (skill.canUse((EntityPlayer)this.mc.field_71439_g)) {
            this.displayStartTime = Minecraft.func_71386_F();
            ((EndingBlow)skill).skillResult = 0;
        } else if (((EndingBlow)skill).getLastActivationTime() < this.displayStartTime) {
            this.displayStartTime = 0L;
        }
        if (skill instanceof EndingBlow) {
            byte i = ((EndingBlow)skill).skillResult;
            int n = this.iconIndex = i < 0 ? 2 : (int)i;
        }
        if (!Config.endingBlowHudResult && this.iconIndex != 0) {
            return false;
        }
        return Minecraft.func_71386_F() - this.displayStartTime < (long)Config.endingBlowHudDisplayTime;
    }

    @Override
    protected void setup(ScaledResolution resolution) {
        String textKey = Skills.endingBlow.getTranslationKey() + (this.iconIndex == 2 ? ".hud.failure" : (this.iconIndex == 1 ? "hud.success" : "hud.activate"));
        this.text = StatCollector.func_74838_a((String)textKey);
        this.height = Config.endingBlowHudText ? this.mc.field_71466_p.field_78288_b : 16;
        this.width = Config.endingBlowHudText ? this.mc.field_71466_p.func_78256_a(this.text) : 16;
        this.setPosX(resolution, Config.endingBlowHudXOffset);
        this.setPosY(resolution, Config.endingBlowHudYOffset);
    }

    @Override
    protected void render(ScaledResolution resolution) {
        if (Config.endingBlowHudText) {
            this.mc.field_71466_p.func_85187_a(this.text, this.x, this.y, 0xFF0000, true);
        } else {
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            float r = this.iconIndex == 1 ? 0.0f : 1.0f;
            float g = this.iconIndex == 2 ? 0.0f : 1.0f;
            float b = 0.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(HUD_ICONS);
            RenderHelperQ.drawTexturedRect(this.x, this.y, this.iconIndex * 16, 0, 16, 16, 256, 256);
            RenderHelperQ.drawTexturedRect(this.x, this.y, this.iconIndex * 16, 16, 16, 16, 256, 256);
            GL11.glPopAttrib();
        }
    }
}

