/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.RenderHelperQ;
import dynamicswordskills.client.gui.GuiContainedElement;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;

@SideOnly(value=Side.CLIENT)
public class GuiImageElement
extends GuiContainedElement {
    protected final ResourceLocation texture;
    protected final int imageHeight;
    protected final int imageWidth;
    protected final int u;
    protected final int v;
    protected final int textureHeight;
    protected final int textureWidth;
    protected Color rgba = new Color(255, 255, 255, 255);
    protected float scale = 1.0f;

    public GuiImageElement(int xPos, int yPos, int width, int height, ResourceLocation texture, int u, int v) {
        this(xPos, yPos, width, height, texture, width, height, u, v, width, height);
    }

    public GuiImageElement(int xPos, int yPos, int width, int height, ResourceLocation texture, int imageWidth, int imageHeight, int u, int v) {
        this(xPos, yPos, width, height, texture, imageWidth, imageHeight, u, v, width, height);
    }

    public GuiImageElement(int xPos, int yPos, int width, int height, ResourceLocation texture, int imageWidth, int imageHeight, int u, int v, int textureWidth, int textureHeight) {
        super(xPos, yPos, width, height);
        this.texture = texture;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.u = u;
        this.v = v;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public GuiImageElement setColor(int r, int g, int b, int a) {
        this.rgba.set(r, g, b, a);
        return this;
    }

    public GuiImageElement setScale(float f) {
        this.scale = f;
        return this;
    }

    public GuiImageElement autoScale() {
        this.scale = (float)this.height / (float)this.textureHeight;
        return this;
    }

    protected ResourceLocation getTextureLocation() {
        return this.texture;
    }

    @Override
    public void setScrollableArea(int width, int height) {
    }

    @Override
    public void drawElement(Minecraft mc, int mouseX, int mouseY) {
        float f = 1.0f / this.scale;
        int dw = Math.round((float)Math.min(this.getDisplayedWidth(), this.remainingWidth) * f);
        int dh = Math.round((float)Math.min(this.getDisplayedHeight(), this.remainingHeight) * f);
        int dx = Math.round((float)this.scrollX * f);
        int dy = Math.round((float)this.scrollY * f);
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)((float)this.rgba.getRed() / 255.0f), (float)((float)this.rgba.getGreen() / 255.0f), (float)((float)this.rgba.getBlue() / 255.0f), (float)((float)this.rgba.getAlpha() / 255.0f));
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        this.drawTexture(mc, mouseX, mouseY, f, dx, dy, dw, dh);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2929);
        GL11.glPopAttrib();
    }

    protected void drawTexture(Minecraft mc, int mouseX, int mouseY, float f, int dx, int dy, int dw, int dh) {
        ResourceLocation img = this.getTextureLocation();
        mc.field_71446_o.func_110577_a(img == null ? this.texture : img);
        RenderHelperQ.drawTexturedRect((float)this.xPos * f, (float)this.yPos * f, this.u + dx, this.v + dy, dw, dh, this.imageWidth, this.imageHeight);
    }
}

