/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.gui.GuiElement;
import dynamicswordskills.client.gui.IGuiElementScrollable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScrollBar
extends GuiElement {
    public final IGuiElementScrollable parent;
    public final GuiElement track;
    public final GuiElement ball;
    public final int ballOffset;
    public final boolean isHorizontal;
    protected final float maxScroll;
    protected float currentScroll;
    protected boolean isScrolling;
    protected boolean wasClicking;
    protected int wheel = 0;

    public GuiScrollBar(IGuiElementScrollable parent, GuiElement track, GuiElement ball) {
        this(parent, track, ball, false);
    }

    public GuiScrollBar(IGuiElementScrollable parent, GuiElement track, GuiElement ball, boolean isHorizontal) {
        this(parent, track, ball, isHorizontal, Math.min(track.xPos, ball.xPos), Math.min(track.yPos, ball.yPos), track.width, track.height);
    }

    public GuiScrollBar(IGuiElementScrollable parent, GuiElement track, GuiElement ball, boolean isHorizontal, int xPos, int yPos, int width, int height) {
        super(xPos, yPos, Math.max(width, Math.max(track.width, ball.width)), Math.max(height, Math.max(track.height, ball.height)));
        this.parent = parent;
        this.track = track;
        this.ball = ball;
        this.isHorizontal = isHorizontal;
        if (this.isHorizontal) {
            this.ballOffset = Math.abs(ball.height - track.height) / 2;
            this.ball.xPos = this.track.xPos;
            this.ball.yPos = this.track.yPos - this.ballOffset;
            this.maxScroll = track.width - ball.width;
        } else {
            this.ballOffset = Math.abs(ball.width - track.width) / 2;
            this.ball.xPos = this.track.xPos - this.ballOffset;
            this.ball.yPos = this.track.yPos;
            this.maxScroll = track.height - ball.height;
        }
    }

    public float getScrollAmount() {
        return this.currentScroll;
    }

    public void resetScroll() {
        this.currentScroll = 0.0f;
    }

    public void handleMouseInput() {
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            this.wheel = i;
        }
    }

    @Override
    public void drawElement(Minecraft mc, int mouseX, int mouseY) {
        this.updateScrollState(mouseX, mouseY);
        this.track.drawElement(mc, mouseX, mouseY);
        if (this.isHorizontal) {
            this.ball.xPos = this.track.xPos + (int)(this.currentScroll * this.maxScroll);
        } else {
            this.ball.yPos = this.track.yPos + (int)(this.currentScroll * this.maxScroll);
        }
        this.ball.drawElement(mc, mouseX, mouseY);
    }

    protected void updateScrollState(int mouseX, int mouseY) {
        boolean flag = Mouse.isButtonDown((int)0);
        if (this.isMouseOverElement(mouseX, mouseY) && !this.wasClicking && flag) {
            this.isScrolling = this.parent.isScrollControlRequired(this.isHorizontal);
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            float f = this.ball.height / 2;
            this.currentScroll = ((float)(mouseY - this.track.yPos) - f) / this.maxScroll;
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        }
        if (this.wheel != 0 && this.parent.isScrollControlRequired(this.isHorizontal)) {
            this.handleMouseWheel(mouseX, mouseY);
        }
    }

    protected int getMaxScroll() {
        return this.isHorizontal ? this.parent.getMaxScrollWidth() : this.parent.getMaxScrollHeight();
    }

    protected void handleMouseWheel(int mouseX, int mouseY) {
        int dy;
        int dx = this.isHorizontal ? 0 : -this.ballOffset;
        int n = dy = this.isHorizontal ? -this.ballOffset : 0;
        if (this.track.isMouseOverElement(mouseX, mouseY, dx, dy) || this.parent.isScrollableByWheel(mouseX, mouseY, this.isHorizontal)) {
            int i = this.parent.getScrollableWheelSpeed(this.isHorizontal) * (this.wheel < 0 ? -1 : 1);
            int j = Math.max(this.getMaxScroll(), 1);
            this.currentScroll -= (float)i / (float)j;
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        }
        this.wheel = 0;
    }
}

