/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dynamicswordskills.api.SkillGroup;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.client.RenderHelperQ;
import dynamicswordskills.client.gui.GuiCompositeScrollBar;
import dynamicswordskills.client.gui.GuiContainedButton;
import dynamicswordskills.client.gui.GuiElement;
import dynamicswordskills.client.gui.GuiElementContainer;
import dynamicswordskills.client.gui.GuiImageElement;
import dynamicswordskills.client.gui.GuiScrollBar;
import dynamicswordskills.client.gui.GuiTextElement;
import dynamicswordskills.client.gui.IGuiElementScrollable;
import dynamicswordskills.client.gui.IGuiPageButton;
import dynamicswordskills.client.gui.JumpToPageButton;
import dynamicswordskills.client.gui.Padding;
import dynamicswordskills.client.gui.Page;
import dynamicswordskills.client.gui.SkillSlot;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiSkills
extends GuiScreen {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("dynamicswordskills:textures/gui/gui_skills.png");
    public static final int TEXT_COLOR = 0x404040;
    public static final int HOVER_COLOR = 0xFFFFA0;
    protected final Map<SkillGroup, Integer> index = Maps.newHashMap();
    protected final List<Page<?>> pages = new ArrayList();
    protected int xSize = 281;
    protected int ySize = 180;
    protected int guiLeft;
    protected int guiTop;
    protected Page<?> pageLeft;
    protected Page<?> pageRight;
    protected Page<?> pageContents;
    protected PageNumberFooter footer;
    protected GuiScrollBar scrollBarLeft;
    protected GuiScrollBar scrollBarRight;
    protected DSSPlayerInfo skills;
    protected SkillBase currentSkill = null;

    public void func_73866_w_() {
        super.func_73866_w_();
        boolean unicodeFlag = this.field_146289_q.func_82883_a();
        this.skills = DSSPlayerInfo.get((EntityPlayer)this.field_146297_k.field_71439_g);
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        if (this.pages.isEmpty()) {
            this.initPages();
        }
        int btns = 0;
        boolean drawPaginationLabel = Config.showPaginationLabels();
        int paginationHeight = drawPaginationLabel ? 22 : 13;
        this.field_146292_n.add(new IGuiPageButton.PageButtonImage(btns++, this.guiLeft + 12, this.guiTop + 158, 16, paginationHeight, new ChatComponentTranslation("skill.dss.gui.button.label.prev", new Object[0]).func_150260_c(), GUI_TEXTURE, 300, 180, 284, 18, 16, 13){

            @Override
            public int getPageIndex(int current, int numPages) {
                return current > 0 ? current - 1 : current;
            }

            public void func_146113_a(SoundHandler handler) {
            }
        }.setDrawLabelText(drawPaginationLabel));
        this.field_146292_n.add(new IGuiPageButton.PageButtonImage(btns++, this.guiLeft + 253, this.guiTop + 158, 16, paginationHeight, new ChatComponentTranslation("skill.dss.gui.button.label.next", new Object[0]).func_150260_c(), GUI_TEXTURE, 300, 180, 284, 31, 16, 13){

            @Override
            public int getPageIndex(int current, int numPages) {
                return current + 1 < numPages ? current + 1 : current;
            }

            public void func_146113_a(SoundHandler handler) {
            }
        }.setDrawLabelText(drawPaginationLabel));
        this.field_146289_q.func_78264_a(true);
        boolean plainText = Config.showPlainTextIndex();
        int h = plainText ? 12 : 14;
        int w = 104;
        int ip = plainText ? 2 : 4;
        int op = 2;
        int max = 80 - ip;
        int i = 1;
        this.field_146292_n.add(new IndexButton(btns++, this.guiLeft + 154, this.guiTop + 55, w, h, new ChatComponentTranslation("skill.dss.gui.button.label.main", new Object[0]).func_150260_c(), 0).pad(ip, 0).setDrawButtonBox(!plainText));
        for (SkillGroup group : SkillGroup.getAll()) {
            Integer pageIndex = this.index.get(group);
            if (pageIndex == null) continue;
            int dy = 55 + i * (h + op);
            String s = group.getDisplayName();
            boolean ellipsis = false;
            while (this.field_146289_q.func_78256_a(s) > max) {
                s = s.substring(0, s.length() - 1);
                ellipsis = true;
            }
            if (ellipsis) {
                s = s + "...";
            }
            this.field_146292_n.add(new GroupIndexButton(group, btns++, this.guiLeft + 154, this.guiTop + dy, w, h, s, pageIndex).pad(ip, 0).setDrawButtonBox(!plainText));
            ++i;
        }
        this.pageContents = this.getTableOfContents();
        if (this.currentSkill == null) {
            this.pageRight = this.pageContents;
            this.scrollBarRight = this.getScrollBar(this.pageRight.body, 259, 3);
        } else {
            this.hideIndexButtons();
        }
        if (this.pageLeft == null) {
            this.setPageLeft(0);
        }
        this.field_146289_q.func_78264_a(unicodeFlag);
    }

    protected void initPages() {
        this.footer = new PageNumberFooter(76, 161, 101, 9);
        this.pages.add(this.getTitlePage());
        SkillSlotContainer container = null;
        for (SkillGroup group : SkillGroup.getAll()) {
            List<SkillBase> skills = group.getSkills(new GroupFilter(this.skills));
            if (skills.isEmpty()) continue;
            group.sort(skills);
            int pageIndex = this.pages.size();
            int op = 3;
            container = (SkillSlotContainer)new SkillSlotContainer(this, group, 18, 32, 110, 127).setElementPadding(0, op).pad(2, 2, 2, 4);
            for (SkillBase skill : skills) {
                if (container.add(new SkillSlot.TitledSkillSlot(skill, 104, 18))) continue;
                if (!container.isEmpty()) {
                    this.pages.add(this.getSkillContainerPage(container));
                }
                container = (SkillSlotContainer)new SkillSlotContainer(this, group, 18, 32, 110, 127).setElementPadding(0, op).pad(2, 2, 2, 4);
                container.add(new SkillSlot.TitledSkillSlot(skill, 104, 18));
            }
            if (!container.isEmpty()) {
                this.pages.add(this.getSkillContainerPage(container));
            }
            if (pageIndex >= this.pages.size()) continue;
            this.index.put(group, pageIndex);
        }
        this.footer.numPages = this.pages.size();
    }

    protected GuiScrollBar getScrollBar(IGuiElementScrollable parent, int x, int dy) {
        return new GuiCompositeScrollBar(parent, (GuiElement)new GuiImageElement(x + 1, 40 + dy, 1, 111 - dy * 2, GUI_TEXTURE, 300, 180, 282, 35), (GuiElement)new GuiImageElement(x, 40 + dy, 3, 7, GUI_TEXTURE, 300, 180, 281, 28), x, 34 + dy, 3, 123 - dy * 2, new GuiImageElement(x, 34 + dy, 3, 5, GUI_TEXTURE, 300, 180, 281, 18), new GuiImageElement(x, 152 - dy, 3, 5, GUI_TEXTURE, 300, 180, 281, 23));
    }

    protected Page<?> getTitlePage() {
        String headerText = new ChatComponentTranslation("skill.dss.gui.main.title", new Object[0]).func_150260_c().toUpperCase();
        GuiTextElement header = new GuiTextElement(42, 26, 80, 9, (IChatComponent)new ChatComponentTranslation(headerText, new Object[0]), 0x404040, false);
        GuiElementContainer<GuiTextElement> body = new GuiElementContainer.GuiTextElementContainer(18, 32, 110, 127).setElementPadding(0, this.field_146297_k.field_71466_p.field_78288_b);
        body.pad(7, 0, 7, 5);
        body.add((GuiTextElement)new GuiTextElement(body, (IChatComponent)new ChatComponentTranslation("skill.dss.gui.main.body", new Object[0]), 0x404040, true).pad(0));
        return new Page(0, 10, 7, 121, 164, body, header, this.footer);
    }

    protected Page<?> getTableOfContents() {
        String headerText = new ChatComponentTranslation("skill.dss.gui.heading.index", new Object[0]).func_150260_c().toUpperCase();
        GuiTextElement header = new GuiTextElement(153, 24, 104, 13, GuiTextElement.getBoldComponent((IChatComponent)new ChatComponentText(headerText), null), 0x404040, true);
        int bh = Config.showPlainTextIndex() ? 12 : 14;
        GuiElementContainer<GuiContainedButton> body = new GuiContainedButton.GuiButtonContainer(153, 37, 110, 117, bh, this.guiLeft, this.guiTop).setElementPadding(0, 2);
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiContainedButton)) continue;
            body.add((GuiContainedButton)button);
        }
        return new Page(0, 148, 7, 121, 164, body, header);
    }

    protected Page<SkillSlot> getSkillContainerPage(SkillSlotContainer body) {
        String headerText = body.group.getDisplayName().toUpperCase();
        GuiTextElement header = new GuiTextElement(42, 24, 79, 9, GuiTextElement.getBoldComponent((IChatComponent)new ChatComponentText(headerText), null), 0x404040, true);
        return new Page<SkillSlot>(this.pages.size(), 10, 7, 121, 164, body, header, this.footer);
    }

    protected Page<?> getSkillDescriptionPage(SkillBase skill) {
        int pad = 5;
        String lvl = String.valueOf(this.currentSkill.getLevel());
        GuiElement.GuiCompositeElement header = new GuiElement.GuiCompositeElement(153, 24, 106, 9, new GuiTextElement(153, 24, 96, 9, GuiTextElement.getBoldComponent((IChatComponent)new ChatComponentTranslation(skill.getDisplayName().toUpperCase(), new Object[0]), EnumChatFormatting.DARK_GRAY), 0x404040, true), new GuiTextElement(250, 24, 11, 9, GuiTextElement.getBoldComponent((IChatComponent)new ChatComponentText(lvl), EnumChatFormatting.DARK_GRAY), 0x404040, true).setCentered(true));
        GuiElementContainer.GuiTextElementContainer body = new GuiElementContainer.GuiTextElementContainer(153, 35, 110, 121);
        body.pad(2, 5, 2, 3);
        if (Config.isSkillDisabled((EntityPlayer)this.field_146297_k.field_71439_g, this.currentSkill)) {
            String tk = "skill.dss.disabled." + (Config.isSkillAllowed(this.currentSkill) ? "client" : "server");
            body.add((GuiTextElement)new GuiTextElement((GuiElement)body, GuiTextElement.getBoldComponent((IChatComponent)new ChatComponentTranslation(tk, new Object[0]), EnumChatFormatting.DARK_RED), 0x404040, true).pad(0, 0, pad, 0));
        }
        body.add(new GuiTextElement((GuiElement)body, GuiTextElement.getBoldComponent((IChatComponent)new ChatComponentTranslation("skill.dss.gui.heading.summary", new Object[0]), null), 0x404040, true));
        ArrayList details = Lists.newArrayList();
        details.add(this.currentSkill.getLevelDisplay(false));
        this.currentSkill.addInformation(details, (EntityPlayer)this.field_146297_k.field_71439_g);
        for (String s : details) {
            body.add(new GuiTextElement((GuiElement)body, (IChatComponent)new ChatComponentText(s), 0x404040, true));
        }
        String activation = this.currentSkill.getActivationDisplay();
        if (activation != null) {
            body.add((GuiTextElement)new GuiTextElement((GuiElement)body, GuiTextElement.getBoldComponent((IChatComponent)new ChatComponentTranslation("skill.dss.gui.heading.activation", new Object[0]), null), 0x404040, true).pad(pad, 0, 0, 0));
            body.add(new GuiTextElement((GuiElement)body, activation, 0x404040, true));
        }
        body.add((GuiTextElement)new GuiTextElement((GuiElement)body, GuiTextElement.getBoldComponent((IChatComponent)new ChatComponentTranslation("skill.dss.gui.heading.description", new Object[0]), null), 0x404040, true).pad(pad, 0, 0, 0));
        body.add(new GuiTextElement((GuiElement)body, (IChatComponent)new ChatComponentTranslation(this.currentSkill.getTranslationKey() + ".description", new Object[0]), 0x404040, true));
        return new Page<GuiTextElement>(0, 148, 7, 121, 164, body, header);
    }

    protected void resetPageRight() {
        if (this.pageRight != null) {
            return;
        }
        if (this.currentSkill != null) {
            this.pageRight = this.getSkillDescriptionPage(this.currentSkill);
            this.hideIndexButtons();
        } else {
            this.pageRight = this.pageContents;
        }
        this.scrollBarRight = this.getScrollBar(this.pageRight.body, 259, 3);
    }

    protected void setPageLeft(int index) {
        index = MathHelper.func_76125_a((int)index, (int)0, (int)(this.pages.size() - 1));
        if (this.pageLeft == null || index != this.pageLeft.index) {
            if (this.pageLeft != null) {
                if (Config.clickedPageSound()) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                }
                if (this.pageLeft.body instanceof SkillSlotContainer) {
                    ((SkillSlotContainer)this.pageLeft.body).clearFilters();
                }
            }
            this.pageLeft = this.pages.get(index);
            this.scrollBarLeft = this.getScrollBar(this.pageLeft.body, 15, 0);
            if (index == 0) {
                this.currentSkill = null;
                this.pageRight = null;
                this.resetPageRight();
            }
            for (GuiButton button : this.field_146292_n) {
                if (button instanceof GroupIndexButton && this.pageLeft != null && this.pageLeft.body instanceof SkillSlotContainer) {
                    boolean flag;
                    ((GroupIndexButton)button).forceHover = flag = ((GroupIndexButton)button).group == ((SkillSlotContainer)this.pageLeft.body).group;
                    continue;
                }
                if (!(button instanceof JumpToPageButton)) continue;
                ((JumpToPageButton)button).forceHover = ((JumpToPageButton)button).pageIndex == index;
            }
        }
    }

    protected void hideIndexButtons() {
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof JumpToPageButton)) continue;
            button.field_146125_m = false;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof GroupIndexButton && this.pageLeft.body instanceof SkillSlotContainer && Keyboard.isKeyDown((int)42)) {
            boolean flag;
            ((GroupIndexButton)button).forceHover = flag = ((SkillSlotContainer)this.pageLeft.body).filter(((GroupIndexButton)button).group);
            if (flag) {
                this.scrollBarLeft.resetScroll();
            }
            if (Config.clickedGroupFilterSound()) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
            return;
        }
        if (button instanceof IGuiPageButton) {
            int index = ((IGuiPageButton)button).getPageIndex(this.pageLeft.index, this.pages.size());
            this.setPageLeft(index);
        }
    }

    protected void func_73869_a(char c, int key) {
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() || key == DSSKeyHandler.keys[2].getKeyCode()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        int index = this.pageLeft.index;
        if (key == 209) {
            ++index;
        } else if (key == 201) {
            --index;
        }
        this.setPageLeft(index);
    }

    public void func_146274_d() {
        super.func_146274_d();
        this.scrollBarLeft.handleMouseInput();
        if (this.pageRight != null) {
            this.scrollBarRight.handleMouseInput();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        SkillSlot slot = this.getSlotAtPosition(mouseX - this.guiLeft, mouseY - this.guiTop);
        if (slot != null && slot.skill != null) {
            switch (mouseButton) {
                case 0: {
                    this.pageRight = null;
                    this.currentSkill = !slot.skill.is(this.currentSkill) ? this.skills.getPlayerSkill(slot.skill) : null;
                    if (!Config.clickedSkillSound()) break;
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    break;
                }
                case 1: {
                    if (!Config.isSkillAllowed(slot.skill) || this.skills.getSkillLevel(slot.skill) <= 0) break;
                    this.skills.toggleDisabledSkill(slot.skill);
                    if (Config.clickedSkillSound()) {
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    }
                    if (!slot.skill.is(this.currentSkill)) break;
                    this.pageRight = this.getSkillDescriptionPage(this.currentSkill);
                }
            }
        }
    }

    public void func_146281_b() {
        this.skills.syncDisabledSkills();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146125_m = this.pageLeft.index > 0;
        ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m = this.pages.size() > 0 && this.pageLeft.index + 1 < this.pages.size();
        this.footer.pageIndex = this.pageLeft.index + 1;
        this.func_146276_q_();
        RenderHelperQ.drawTexturedRect(GUI_TEXTURE, (double)this.guiLeft, (double)this.guiTop, 0, 0, this.xSize, this.ySize, 300, 180);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        this.resetPageRight();
        this.drawForegroundLayer(mouseX - this.guiLeft, mouseY - this.guiTop);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    protected void drawForegroundLayer(int mouseX, int mouseY) {
        if (this.pageRight != null) {
            if (this.pageRight.body.isScrollControlRequired(this.scrollBarRight.isHorizontal)) {
                this.scrollBarRight.drawElement(this.field_146297_k, mouseX, mouseY);
                this.pageRight.body.scrollElementTo(this.scrollBarRight.getScrollAmount(), this.scrollBarRight.isHorizontal);
            }
            this.pageRight.drawElement(this.field_146297_k, mouseX, mouseY);
        }
        if (this.pageLeft.body.isScrollControlRequired(this.scrollBarLeft.isHorizontal)) {
            this.scrollBarLeft.drawElement(this.field_146297_k, mouseX, mouseY);
            this.pageLeft.body.scrollElementTo(this.scrollBarLeft.getScrollAmount(), this.scrollBarLeft.isHorizontal);
        }
        this.pageLeft.drawElement(this.field_146297_k, mouseX, mouseY);
        if (Config.showSkillGroupTooltips()) {
            this.displaySkillGroupTooltip(mouseX, mouseY);
        }
    }

    protected void displaySkillGroupTooltip(int mouseX, int mouseY) {
        for (GuiButton button : this.field_146292_n) {
            List<String> tooltip;
            if (!button.field_146125_m || !button.func_146115_a()) continue;
            if (!(button instanceof GroupIndexButton) || (tooltip = ((GroupIndexButton)button).group.getTooltip()) == null || tooltip.isEmpty()) break;
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146297_k.field_71466_p);
            break;
        }
    }

    protected SkillSlot getSlotAtPosition(int x, int y) {
        if (!(this.pageLeft.body instanceof SkillSlotContainer)) {
            return null;
        }
        for (SkillSlot slot : ((SkillSlotContainer)this.pageLeft.body).getElements()) {
            if (!slot.isMouseOverElement(x - this.pageLeft.body.padding.left, y)) continue;
            int maxY = this.pageLeft.body.yPos + this.pageLeft.body.height - this.pageLeft.body.getPadding().height();
            return slot.getElementPosY() + slot.getPadding().height() < maxY ? slot : null;
        }
        return null;
    }

    public static class SkillSlotContainer
    extends GuiElementContainer<SkillSlot> {
        public final GuiSkills skillScreen;
        protected SkillSlot hovered;
        @Nullable
        public final SkillGroup group;
        protected final Set<SkillGroup> filters = Sets.newHashSet();

        public SkillSlotContainer(GuiSkills screen, @Nullable SkillGroup group, int xPos, int yPos, int width, int height) {
            super(xPos, yPos, width, height);
            this.skillScreen = screen;
            this.group = group;
            this.lineHeight = 18;
        }

        public boolean filter(SkillGroup filter) {
            if (filter == this.group) {
                return true;
            }
            boolean removed = this.filters.contains(filter);
            if (removed) {
                this.filters.remove(filter);
            } else {
                this.filters.add(filter);
            }
            for (SkillSlot s : this.elements) {
                if (s.skill == null) continue;
                boolean flag = false;
                for (SkillGroup g : this.filters) {
                    if (Config.isSkillInGroup(s.skill, g)) continue;
                    flag = true;
                    break;
                }
                s.setDisabled(flag);
            }
            this.markDirty();
            return !removed;
        }

        public void clearFilters() {
            this.filters.clear();
            for (SkillSlot s : this.elements) {
                s.setDisabled(false);
            }
            this.markDirty();
        }

        @Override
        public boolean canAdd(@Nullable SkillSlot slot) {
            return slot.skill == null || Config.isSkillInGroup(slot.skill, this.group);
        }

        @Override
        protected void onElementAdded(@Nullable SkillSlot element) {
            if (element != null) {
                int i = this.elements.size() - 1;
                element.setElementPosition(this.xPos, this.yPos + i * (element.height + this.elementPadY));
            }
        }

        public SkillSlotContainer setElementPadding(int x, int y) {
            super.setElementPadding(x, y);
            this.lineHeight = 18 + y;
            return this;
        }

        @Override
        public void drawElement(Minecraft mc, int mouseX, int mouseY) {
            this.hovered = null;
            super.drawElement(mc, mouseX, mouseY);
            if (this.hovered != null && this.hovered.skill != null) {
                SkillBase instance = this.skillScreen.skills.getPlayerSkill(this.hovered.skill);
                this.renderToolTip(instance == null ? this.hovered.skill : instance, mc, mouseX, mouseY);
            }
        }

        @Override
        protected void drawElement(SkillSlot slot, Minecraft mc, int mouseX, int mouseY) {
            slot.isSkillKnown = this.skillScreen.skills.getSkillLevel(slot.skill) > 0;
            slot.selected = slot.skill != null && slot.skill.is(this.skillScreen.currentSkill);
            super.drawElement(slot, mc, mouseX, mouseY);
            if (slot.isMouseOverElement(mouseX, mouseY)) {
                this.hovered = slot;
                slot.drawHoveredGradient(-2130706433, -2130706433, new Padding(-1, -2, -1, -1));
            }
            if (slot.selected) {
                int a = 204;
                int r = 204;
                int g = 102;
                int b = 0;
                int c = (a << 24) + (r << 16) + (g << 8) + b;
                slot.drawBorderBox(2, c);
            }
        }

        protected void renderToolTip(SkillBase skill, Minecraft mc, int mouseX, int mouseY) {
            boolean unicodeFlag = mc.field_71466_p.func_82883_a();
            mc.field_71466_p.func_78264_a(false);
            ArrayList tooltip = Lists.newArrayList();
            if (skill.getLevel() < 1) {
                String displayName = skill.showNameIfUnknown((EntityPlayer)mc.field_71439_g) ? skill.getDisplayName() : new ChatComponentTranslation("skill.dss.unknown.name", new Object[0]).func_150260_c();
                tooltip.add(displayName);
                if (Config.isSkillAllowed(skill)) {
                    tooltip.add(EnumChatFormatting.GRAY + EnumChatFormatting.ITALIC + new ChatComponentTranslation("skill.dss.unknown.tooltip", new Object[0]).func_150260_c());
                } else {
                    tooltip.add(EnumChatFormatting.DARK_RED + new ChatComponentTranslation("skill.dss.disabled.server", new Object[0]).func_150260_c());
                }
            } else if (!Config.isSkillAllowed(skill)) {
                tooltip.add(skill.getDisplayName());
                tooltip.add(EnumChatFormatting.DARK_RED + new ChatComponentTranslation("skill.dss.disabled.server", new Object[0]).func_150260_c());
            } else {
                tooltip.add(skill.getDisplayName());
                if (this.skillScreen.skills.isSkillDisabled(skill)) {
                    tooltip.add(EnumChatFormatting.DARK_RED + new ChatComponentTranslation("skill.dss.disabled.client", new Object[0]).func_150260_c());
                }
                tooltip.add(EnumChatFormatting.GOLD + skill.getLevelDisplay(false));
                for (String s : skill.getTooltip((EntityPlayer)this.skillScreen.field_146297_k.field_71439_g, false)) {
                    tooltip.add(EnumChatFormatting.GRAY + s);
                }
            }
            this.skillScreen.drawHoveringText(tooltip, mouseX, mouseY, mc.field_71466_p);
            mc.field_71466_p.func_78264_a(unicodeFlag);
        }
    }

    public static class GroupIndexButton
    extends IndexButton {
        public final SkillGroup group;

        public GroupIndexButton(SkillGroup group, int id, int x, int y, int width, int height, String label, int pageIndex) {
            super(id, x, y, width, height, label, pageIndex);
            this.group = group;
        }
    }

    public static class IndexButton
    extends JumpToPageButton {
        public IndexButton(int id, int x, int y, int width, int height, String label, int pageIndex) {
            super(id, x, y, width, height, label, pageIndex);
        }

        public void func_146113_a(SoundHandler handler) {
        }
    }

    public static class PageNumberFooter
    extends GuiElement {
        public int numPages;
        public int pageIndex;

        public PageNumberFooter(int xPos, int yPos, int width, int height) {
            super(xPos, yPos, width, height);
        }

        @Override
        public void drawElement(Minecraft mc, int mouseX, int mouseY) {
            if (this.numPages > 1) {
                String s = String.valueOf(this.pageIndex);
                mc.field_71466_p.func_78276_b(s, this.xPos - mc.field_71466_p.func_78256_a(s) / 2, this.yPos, 0x404040);
            }
        }
    }

    protected static class GroupFilter
    implements Predicate<SkillBase> {
        private final DSSPlayerInfo skills;

        public GroupFilter(DSSPlayerInfo skills) {
            this.skills = skills;
        }

        @Override
        public boolean test(SkillBase t) {
            if (!Config.showBannedSkills() && !Config.isSkillAllowed(t)) {
                return false;
            }
            return Config.showUnknownSkills() || this.skills.getSkillLevel(t) > 0;
        }
    }
}

