/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.gui.GuiContainedElement;
import dynamicswordskills.client.gui.GuiImageElement;
import dynamicswordskills.client.gui.GuiSkills;
import dynamicswordskills.client.gui.GuiTextElement;
import dynamicswordskills.client.gui.Padding;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillBase;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class SkillSlot
extends GuiContainedElement {
    public boolean selected;
    public boolean isSkillKnown;
    @Nullable
    protected final SkillBase skill;
    protected final GuiImageElement frame;
    protected final GuiImageElement iconKnown;
    protected final GuiImageElement iconUnknown;

    public SkillSlot(@Nullable SkillBase skill, int width, int height) {
        this(skill, 0, 0, width, height);
    }

    public SkillSlot(@Nullable SkillBase skill, int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width, height);
        this.skill = skill;
        this.frame = new GuiImageElement(this.xPos, this.yPos, 18, 18, GuiSkills.GUI_TEXTURE, 300, 180, 281, 0);
        this.iconUnknown = new SkillIconElement(this.xPos + 1, this.yPos + 1, SkillBase.DEFAULT_ICON);
        if (this.skill != null) {
            int res = this.skill.getIconResolution();
            this.iconKnown = new SkillIconElement(this.xPos + 1, this.yPos + 1, this.skill.getIconLocation(), res, res);
        } else {
            this.iconKnown = new SkillIconElement(this.xPos + 1, this.yPos + 1, SkillBase.DEFAULT_ICON);
        }
    }

    @Override
    public void setElementPosition(int xPos, int yPos) {
        super.setElementPosition(xPos, yPos);
        this.frame.setElementPosition(xPos, yPos);
        int dy = this.scrollY < 1 ? 1 : 0;
        this.iconKnown.setElementPosition(xPos + 1, yPos + dy);
        this.iconUnknown.setElementPosition(xPos + 1, yPos + dy);
    }

    @Override
    public boolean setRemainingDisplayArea(int width, int height) {
        super.setRemainingDisplayArea(width, height);
        this.frame.setRemainingDisplayArea(width, height);
        int dy = this.scrollY < 1 ? 1 : 0;
        this.iconKnown.setRemainingDisplayArea(width - 1, height - dy);
        this.iconUnknown.setRemainingDisplayArea(width - 1, height - dy);
        return true;
    }

    @Override
    public void setScrolledAmount(int scrollX, int scrollY) {
        super.setScrolledAmount(scrollX, scrollY);
        this.frame.setScrolledAmount(scrollX, scrollY);
        int dy = this.scrollY > 0 && this.scrollY < this.frame.height ? 1 : 0;
        this.iconKnown.setScrolledAmount(scrollX, scrollY - dy);
        this.iconUnknown.setScrolledAmount(scrollX, scrollY - dy);
    }

    @Override
    public void setScrollableArea(int width, int height) {
    }

    @Override
    public void drawElement(Minecraft mc, int mouseX, int mouseY) {
        boolean grayScale = Config.isSkillDisabled((EntityPlayer)mc.field_71439_g, this.skill);
        int rgb = grayScale ? 136 : 255;
        this.frame.setColor(rgb, rgb, rgb, 255);
        this.frame.drawElement(mc, mouseX, mouseY);
        if (this.isSkillKnown || this.skill.showIconIfUnknown((EntityPlayer)mc.field_71439_g)) {
            this.iconKnown.setColor(rgb, rgb, rgb, 255);
            this.iconKnown.drawElement(mc, mouseX, mouseY);
        } else {
            this.iconUnknown.setColor(rgb, rgb, rgb, 255);
            this.iconUnknown.drawElement(mc, mouseX, mouseY);
        }
    }

    public void drawBorderBox(int border, int color) {
        if (this.scrollY < 1) {
            this.drawHoveredGradient(color, color, this.xPos - border + 1, this.yPos - border, this.xPos + this.width + border, this.yPos - border + 1);
        }
        if (this.scrollY < this.height + this.getPadding().top) {
            int y1 = this.yPos - Math.max(border, border - this.scrollY);
            int y2 = this.yPos + this.getDisplayedHeight() + border;
            if (this.remainingHeight >= this.height + this.padding.top) {
                this.drawHoveredGradient(color, color, this.xPos - border + 1, y2 - 1, this.xPos + this.width + border, y2);
            } else {
                y2 = this.yPos + this.remainingHeight;
            }
            this.drawHoveredGradient(color, color, this.xPos - border, y1, this.xPos - border + 1, y2);
            this.drawHoveredGradient(color, color, this.xPos + this.width + border, y1, this.xPos + this.width + border + 1, y2);
        }
    }

    public static class TitledSkillSlot
    extends SkillSlot {
        protected final GuiTextElement titleKnown;
        protected final GuiTextElement titleUnknown;
        public boolean isTitleVisible = true;

        public TitledSkillSlot(SkillBase skill, int width, int height) {
            this(skill, 0, 0, width, height);
        }

        public TitledSkillSlot(SkillBase skill, int xPos, int yPos, int width, int height) {
            super(skill, xPos, yPos, width, height);
            if (this.skill == null) {
                this.titleKnown = null;
                this.titleUnknown = null;
            } else {
                this.titleKnown = new GuiTextElement(xPos, yPos, this.width, this.height, (IChatComponent)new ChatComponentTranslation(this.skill.getNameTranslationKey(), new Object[0]), 0x404040, false).setHoverable(true).setHoverColor(0xFFFFA0).setDrawTextShadown(true);
                this.titleUnknown = new GuiTextElement(xPos, yPos, this.width, this.height, (IChatComponent)new ChatComponentTranslation("skill.dss.unknown.name", new Object[0]), 0x404040, false);
            }
        }

        @Override
        public void setElementPosition(int xPos, int yPos) {
            super.setElementPosition(xPos, yPos);
            if (this.skill != null) {
                this.titleKnown.setElementPosition(xPos, yPos);
                this.titleUnknown.setElementPosition(xPos, yPos);
            }
        }

        @Override
        public boolean setRemainingDisplayArea(int width, int height) {
            super.setRemainingDisplayArea(width, height);
            if (this.skill != null) {
                this.titleKnown.setRemainingDisplayArea(width, height);
                this.titleUnknown.setRemainingDisplayArea(width, height);
            }
            return true;
        }

        @Override
        public void setScrolledAmount(int scrollX, int scrollY) {
            super.setScrolledAmount(scrollX, scrollY);
            if (this.skill != null) {
                this.titleKnown.setScrolledAmount(scrollX, scrollY);
                this.titleUnknown.setScrolledAmount(scrollX, scrollY);
            }
        }

        @Override
        public void drawElement(Minecraft mc, int mouseX, int mouseY) {
            if (this.isTitleVisible && this.skill != null) {
                GuiTextElement title = this.isSkillKnown || this.skill.showNameIfUnknown((EntityPlayer)mc.field_71439_g) ? this.titleKnown : this.titleUnknown;
                title.setHoverable(this.isSkillKnown);
                int ht = (title.getContentHeight() - title.getPadding().height()) / 2;
                int dy = mc.field_71466_p.field_78288_b - ht;
                title.forceHover = this.selected;
                if (this.selected) {
                    title.pad(dy, 0, dy - 1, 0);
                    int c = 0x5C000000;
                    title.drawHoveredGradient(c, c, new Padding(-1, -2, -1, -1));
                }
                title.pad(dy, 0, dy - 1, 22);
                title.drawElement(mc, mouseX, mouseY);
            }
            super.drawElement(mc, mouseX, mouseY);
        }
    }

    public static class SkillIconElement
    extends GuiImageElement {
        public SkillIconElement(int xPos, int yPos, ResourceLocation texture) {
            this(xPos, yPos, texture, 16, 16);
        }

        public SkillIconElement(int xPos, int yPos, ResourceLocation texture, int imageWidth, int imageHeight) {
            super(xPos, yPos, 16, 16, texture, imageWidth, imageHeight, 0, 0, imageWidth, imageHeight);
            if (imageWidth != 16) {
                this.autoScale();
            }
        }
    }
}

