/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.item;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.IMetadataSkillItem;
import dynamicswordskills.api.IRandomSkill;
import dynamicswordskills.api.ISkillInfusionFuelItem;
import dynamicswordskills.api.ItemGrantSkill;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.skills.SkillBase;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class ItemSkillOrb
extends ItemGrantSkill
implements ISkillInfusionFuelItem,
IMetadataSkillItem,
IRandomSkill {
    @SideOnly(value=Side.CLIENT)
    private BiMap<Integer, IIcon> icons;
    private final BiMap<Integer, ResourceLocation> skill_id_map;

    public ItemSkillOrb(BiMap<Integer, ResourceLocation> skill_id_map) {
        if (skill_id_map == null || skill_id_map.isEmpty()) {
            throw new IllegalArgumentException("Skill orb items require a valid ID map with at least one entry");
        }
        this.skill_id_map = skill_id_map;
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(DynamicSwordSkills.tabSkills);
    }

    @Override
    public SkillBase getSkillToGrant(ItemStack stack) {
        return this.getSkillFromDamage(stack.func_77960_j());
    }

    @Override
    public SkillBase getSkillToInfuse(ItemStack stack) {
        return this.getSkillFromDamage(stack.func_77960_j());
    }

    @Override
    public int getAdjustedInfusionCost(ItemStack orb, ItemStack base, int required) {
        return required;
    }

    @Override
    public int getItemDamage(SkillBase skill) {
        Integer i = (Integer)this.skill_id_map.inverse().get((Object)skill.getRegistryName());
        return i == null ? -1 : i;
    }

    @Override
    public SkillBase getSkillFromDamage(int damage) {
        return SkillRegistry.get((ResourceLocation)this.skill_id_map.get((Object)damage));
    }

    @Override
    public SkillBase getRandomSkill(Random rand) {
        return this.getSkillFromDamage(rand.nextInt(this.skill_id_map.size()));
    }

    public String func_77653_i(ItemStack stack) {
        SkillBase skill = this.getSkillFromDamage(stack.func_77960_j());
        return StatCollector.func_74837_a((String)(super.func_77658_a() + ".name"), (Object[])new Object[]{skill == null ? "" : skill.getDisplayName()});
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return (IIcon)this.icons.get((Object)(damage % this.icons.size()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        Iterator iterator = this.skill_id_map.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = HashBiMap.create((int)this.skill_id_map.size());
        for (Map.Entry entry : this.skill_id_map.entrySet()) {
            this.icons.put(entry.getKey(), (Object)register.func_94245_a("dynamicswordskills:skillorb_" + ((ResourceLocation)entry.getValue()).func_110623_a().toLowerCase()));
        }
    }
}

