/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network.bidirectional;

import cpw.mods.fml.relauncher.Side;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractMessage;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class ActionTimePacket
extends AbstractMessage<ActionTimePacket> {
    private int ticks;
    private boolean isAttack;

    public ActionTimePacket() {
    }

    public ActionTimePacket(int ticks, boolean isAttack) {
        this.ticks = ticks;
        this.isAttack = isAttack;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.ticks = buffer.readInt();
        this.isAttack = buffer.readBoolean();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.ticks);
        buffer.writeBoolean(this.isAttack);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if (this.isAttack) {
            DSSPlayerInfo.get(player).setAttackCooldown(this.ticks);
        } else {
            DSSPlayerInfo.get(player).setUseItemCooldown(this.ticks);
        }
    }
}

