/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network.bidirectional;

import cpw.mods.fml.relauncher.Side;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractMessage;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class ActivateSkillPacket
extends AbstractMessage<ActivateSkillPacket> {
    private byte id;
    private boolean wasTriggered = false;

    public ActivateSkillPacket() {
    }

    public ActivateSkillPacket(SkillBase skill, boolean wasTriggered) {
        this.id = skill.getId();
        this.wasTriggered = wasTriggered;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.id = buffer.readByte();
        this.wasTriggered = buffer.readBoolean();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeByte((int)this.id);
        buffer.writeBoolean(this.wasTriggered);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        DSSPlayerInfo info = DSSPlayerInfo.get(player);
        SkillBase skill = info.getPlayerSkill(SkillRegistry.getSkillById(this.id));
        if (skill instanceof SkillActive) {
            info.activateSkill(skill, this.wasTriggered);
        } else {
            DynamicSwordSkills.logger.warn(String.format("Skill ID %d was not valid for %s while processing ActivateSkillPacket", this.id, player));
        }
    }
}

