/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network.bidirectional;

import cpw.mods.fml.relauncher.Side;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractMessage;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class DeactivateSkillPacket
extends AbstractMessage<DeactivateSkillPacket> {
    private byte id;

    public DeactivateSkillPacket() {
    }

    public DeactivateSkillPacket(SkillActive skill) {
        this.id = skill.getId();
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.id = buffer.readByte();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeByte((int)this.id);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        SkillBase skill = DSSPlayerInfo.get(player).getPlayerSkill(SkillRegistry.getSkillById(this.id));
        if (skill instanceof SkillActive) {
            ((SkillActive)skill).deactivate(player);
        } else {
            DynamicSwordSkills.logger.warn(String.format("Skill ID %d was not valid for %s while processing DeactivateSkillPacket", this.id, player));
        }
    }
}

