/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network.server;

import cpw.mods.fml.relauncher.Side;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractMessage;
import dynamicswordskills.skills.IModifiableSkill;
import dynamicswordskills.skills.ISkillModifier;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class ApplySkillModifierPacket
extends AbstractMessage.AbstractServerMessage<ApplySkillModifierPacket> {
    private byte skillId;
    private byte modifierId;

    public ApplySkillModifierPacket() {
    }

    public <T extends SkillActive, M extends SkillBase> ApplySkillModifierPacket(T skill, M modifier) {
        this.skillId = skill.getId();
        this.modifierId = modifier.getId();
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.skillId = buffer.readByte();
        this.modifierId = buffer.readByte();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeByte((int)this.skillId);
        buffer.writeByte((int)this.modifierId);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        DSSPlayerInfo skills = DSSPlayerInfo.get(player);
        SkillActive skill = skills.getActiveSkill(SkillRegistry.getSkillById(this.skillId));
        SkillBase refMod = SkillRegistry.getSkillById(this.modifierId);
        SkillBase modifier = skills.getPlayerSkill(refMod);
        if (skill instanceof IModifiableSkill && skill.isActive() && modifier instanceof ISkillModifier && modifier.getLevel() > 0) {
            if (!((IModifiableSkill)((Object)skill)).getSkillModifiers().contains(refMod)) {
                DynamicSwordSkills.logger.error(String.format("Received invalid skill modifier %s for skill %s", modifier.getRegistryName().toString(), skill.getRegistryName().toString()));
            } else {
                this.applySkillModifier((IModifiableSkill)((Object)skill), modifier, player);
            }
        }
    }

    private <M extends SkillBase> void applySkillModifier(IModifiableSkill skill, SkillBase modifier, EntityPlayer player) {
        skill.applySkillModifier(modifier, player);
    }
}

