/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network.server;

import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractMessage;
import java.io.IOException;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class SyncDisabledSkillsPacket
extends AbstractMessage.AbstractServerMessage<SyncDisabledSkillsPacket> {
    private Set<Byte> disabledIds = Sets.newHashSet();

    public SyncDisabledSkillsPacket() {
    }

    public SyncDisabledSkillsPacket(EntityPlayer player) {
        this.disabledIds = DSSPlayerInfo.get(player).getDisabledSkillIds();
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        int n = buffer.readInt();
        for (int i = 0; i < n; ++i) {
            this.disabledIds.add(buffer.readByte());
        }
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.disabledIds.size());
        for (Byte b : this.disabledIds) {
            buffer.writeByte((int)b.byteValue());
        }
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        DSSPlayerInfo.get(player).setDisabledSkills(this.disabledIds);
    }
}

