/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.api.SkillGroup;
import dynamicswordskills.client.DSSClientEvents;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.Skills;
import dynamicswordskills.util.DamageUtils;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ArmorBreak
extends SkillActive {
    private int activeTimer = 0;
    private int charge = 0;
    private boolean wasLockedOn;
    @SideOnly(value=Side.CLIENT)
    private KeyBinding attackKey;

    public ArmorBreak(String translationKey) {
        super(translationKey);
    }

    private ArmorBreak(ArmorBreak skill) {
        super(skill);
    }

    @Override
    public ArmorBreak newInstance() {
        return new ArmorBreak(this);
    }

    @Override
    public boolean displayInGroup(SkillGroup group) {
        return super.displayInGroup(group) || group == Skills.WEAPON_GROUP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getChargeDisplay(this.getChargeTime(player)));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    protected boolean allowUserActivation() {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    private int getChargeTime(EntityPlayer player) {
        return 20 - this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isWeapon(player.func_70694_bm());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key, boolean isLockedOn) {
        if (Config.requiresLockOn() && !isLockedOn) {
            return this.charge > 0 && key == mc.field_71474_y.field_74312_F;
        }
        this.wasLockedOn = isLockedOn;
        return key == mc.field_71474_y.field_74312_F;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.wasLockedOn || mc.field_71476_x == null || mc.field_71476_x.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            this.attackKey = key;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void keyReleased(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == this.attackKey) {
            this.attackKey = null;
            this.charge = 0;
            DSSPlayerInfo.get(player).setArmSwingProgress(0.0f, 0.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void initCharging(EntityPlayer player) {
        if (this.charge == 0 && this.attackKey != null && this.attackKey.func_151470_d() && DSSPlayerInfo.get(player).canInteract()) {
            this.charge = this.getChargeTime(player);
            KeyBinding.func_74510_a((int)this.attackKey.func_151463_i(), (boolean)false);
        }
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.activeTimer = 4;
        if (world.field_72995_K) {
            this.attackKey = null;
            DSSPlayerInfo.get(player).setArmSwingProgress(0.0f, 0.0f);
            DSSClientEvents.handlePlayerAttack(Minecraft.func_71410_x());
        }
        return true;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.activeTimer = 0;
        this.charge = 0;
        DSSPlayerInfo.get(player).setArmSwingProgress(0.0f, 0.0f);
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            this.initCharging(player);
        }
        if (this.isActive()) {
            --this.activeTimer;
        } else if (this.charge > 0) {
            if (PlayerUtils.isWeapon(player.func_70694_bm())) {
                int maxCharge = this.getChargeTime(player);
                if (this.charge < maxCharge - 1) {
                    float f = 0.25f + 0.75f * ((float)(maxCharge - this.charge) / (float)maxCharge);
                    DSSPlayerInfo.get(player).setArmSwingProgress(f, 0.0f);
                }
                --this.charge;
                if (this.charge == 0) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this, true));
                }
            } else {
                DSSPlayerInfo.get(player).setArmSwingProgress(0.0f, 0.0f);
                this.charge = 0;
            }
        }
    }

    @Override
    public boolean onAttack(EntityPlayer player, EntityLivingBase entity, DamageSource source, float amount) {
        this.activeTimer = 0;
        entity.func_70097_a(DamageUtils.causeArmorBreakDamage((Entity)player), amount);
        if (!player.field_70170_p.field_72995_K) {
            PlayerUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "dynamicswordskills:armorbreak", 0.4f, 0.5f);
        }
        return true;
    }
}

