/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DSSCombatEvents;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.SkillGroup;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.server.EndComboPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.IComboSkill;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.Skills;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class BackSlice
extends SkillActive {
    @SideOnly(value=Side.CLIENT)
    private KeyBinding keyPressed;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private int dodgeTimer = 0;
    private boolean impacted;
    private boolean success;
    private SkillActive targetingSkill;

    public BackSlice(String translationKey) {
        super(translationKey);
    }

    private BackSlice(BackSlice skill) {
        super(skill);
    }

    @Override
    public BackSlice newInstance() {
        return new BackSlice(this);
    }

    @Override
    public boolean displayInGroup(SkillGroup group) {
        return super.displayInGroup(group) || group == Skills.SWORD_GROUP || group == Skills.TARGETED_GROUP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.func_74837_a((String)(this.getTranslationKey() + ".info.angle"), (Object[])new Object[]{360 - 2 * this.getAttackAngle()}));
        String chance = String.format("%.2f", Float.valueOf(BackSlice.getDisarmorChance(null, player.func_70694_bm(), this.level)));
        desc.add(StatCollector.func_74837_a((String)(this.getTranslationKey() + ".info.chance"), (Object[])new Object[]{chance}));
        desc.add(this.getDamageDisplay(this.level * 10, true) + "%");
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    private int getActiveTime() {
        return 15 + this.level;
    }

    private int getAttackAngle() {
        return 160 - this.level * 10;
    }

    private int getDodgeTime() {
        return 10 - this.level;
    }

    public static float getDisarmorChance(ItemStack armorStack, ItemStack weapon, int level) {
        float chance = (float)level * 0.05f;
        if (armorStack != null && armorStack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)armorStack.func_77973_b();
            int i = armor.func_82812_d().func_78044_b(armor.field_77881_a);
            chance += (float)(5 - i) * 0.05f;
            i = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)armorStack);
            if (i > 0) {
                chance -= (float)i * 0.05f;
            }
        }
        if (weapon != null) {
            int i = EnchantmentHelper.func_77506_a((int)Enchantment.field_77338_j.field_77352_x, (ItemStack)weapon);
            if (i > 0) {
                chance += (float)i * 0.05f;
            }
        } else {
            chance -= 1.0f;
        }
        return chance;
    }

    @Override
    public boolean isActive() {
        return this.dodgeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 1.0f - 0.1f * (float)this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        ILockOnTarget lock = DSSPlayerInfo.get(player).getTargetingSkill();
        return super.canUse(player) && !this.isActive() && !player.func_71039_bw() && PlayerUtils.isSwordOrProvider(player.func_70694_bm(), this) && lock != null && lock.isLockedOn();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.field_70122_E && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key, boolean isLockedOn) {
        if (!isLockedOn) {
            return false;
        }
        if (this.isAnimating()) {
            return key == mc.field_71474_y.field_74312_F;
        }
        return key == DSSKeyHandler.keys[3].getKey() || key == DSSKeyHandler.keys[5].getKey() || key == DSSKeyHandler.keys[6].getKey() || Config.allowVanillaControls() && (key == mc.field_71474_y.field_74351_w || key == mc.field_71474_y.field_74370_x || key == mc.field_71474_y.field_74366_z);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void keyPressedWhileAnimating(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.isActive()) {
            Entity target = TargetUtils.getMouseOverEntity();
            if (target == null && this.targetingSkill instanceof ILockOnTarget && this.targetingSkill.isActive()) {
                target = ((ILockOnTarget)((Object)this.targetingSkill)).getCurrentTarget();
            }
            if (target != null && TargetUtils.canReachTarget(player, target)) {
                mc.field_71442_b.func_78764_a((EntityPlayer)mc.field_71439_g, target);
            } else {
                PlayerUtils.playRandomizedSound(player, "dynamicswordskills:swordmiss", 0.4f, 0.5f);
                IComboSkill combo = DSSPlayerInfo.get(player).getComboSkill();
                if (combo != null && combo.isComboInProgress()) {
                    PacketDispatcher.sendToServer(new EndComboPacket((SkillBase)((Object)combo)));
                }
            }
            player.func_71038_i();
            DSSCombatEvents.setPlayerAttackTime((EntityPlayer)mc.field_71439_g);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            if (this.keyPressed != null && this.keyPressed.func_151470_d() && (Config.allowVanillaControls() && key == mc.field_71474_y.field_74351_w || key == DSSKeyHandler.keys[3].getKey())) {
                if (this.ticksTilFail > 0) {
                    this.ticksTilFail = 0;
                    return this.activate(player);
                }
                this.ticksTilFail = 6;
            } else if (key != mc.field_71474_y.field_74351_w && key != DSSKeyHandler.keys[3].getKey()) {
                this.keyPressed = key;
            }
        }
        return false;
    }

    @Override
    public boolean onActivated(World world, EntityPlayer player) {
        this.dodgeTimer = this.getActiveTime();
        this.targetingSkill = (SkillActive)((Object)DSSPlayerInfo.get(player).getTargetingSkill());
        this.impacted = false;
        this.success = false;
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.dodgeTimer = 0;
        this.targetingSkill = null;
        if (world.field_72995_K) {
            this.keyPressed = null;
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            --this.dodgeTimer;
            if (this.impacted) {
                this.deactivate(player);
            }
        } else if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0 && --this.ticksTilFail == 0) {
            this.keyPressed = null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.dodgeTimer > this.level;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        if (player.field_70122_E) {
            if (DynamicSwordSkills.proxy.getDebugFPS() < 90 && this.targetingSkill != null && this.targetingSkill.isActive()) {
                this.targetingSkill.onRenderTick(player, partialTickTime);
            }
            double speed = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            double fps = 30.0f / (float)DynamicSwordSkills.proxy.getDebugFPS();
            double d = 1.125 * fps * speed;
            if (player.func_70090_H() || player.func_70058_J()) {
                d *= 0.15;
            }
            Vec3 vec3 = player.func_70040_Z();
            if (this.keyPressed == DSSKeyHandler.keys[6].getKey() || this.keyPressed == Minecraft.func_71410_x().field_71474_y.field_74366_z) {
                player.func_70024_g(-vec3.field_72449_c * d, 0.0, vec3.field_72450_a * d);
            } else {
                player.func_70024_g(vec3.field_72449_c * d, 0.0, -vec3.field_72450_a * d);
            }
            player.func_70024_g(vec3.field_72450_a * d, 0.0, vec3.field_72449_c * d);
        }
        return false;
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        ILockOnTarget targeting = DSSPlayerInfo.get(player).getTargetingSkill();
        return this.dodgeTimer > this.getDodgeTime() && targeting != null && targeting.getCurrentTarget() == source.func_76346_g();
    }

    @Override
    public float onImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        this.impacted = true;
        if (this.isActive() && this.dodgeTimer <= this.getActiveTime() - 5 && !TargetUtils.isTargetInFrontOf((Entity)entity, (Entity)player, this.getAttackAngle())) {
            amount *= 1.0f + (float)this.level * 0.1f;
            PlayerUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "dynamicswordskills:mortaldraw", 0.4f, 0.5f);
            this.success = true;
        }
        return amount;
    }

    @Override
    public void postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        ItemStack armor;
        if ((this.success && Config.canDisarmorPlayers() || !(entity instanceof EntityPlayer)) && (armor = entity.func_71124_b(3)) != null && player.field_70170_p.field_73012_v.nextFloat() < BackSlice.getDisarmorChance(armor, player.func_70694_bm(), this.level)) {
            PlayerUtils.spawnItemWithRandom(entity.field_70170_p, armor, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            entity.func_70062_b(3, null);
        }
    }
}

