/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.client.UpdateComboPacket;
import dynamicswordskills.skills.SkillBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class Combo {
    private final byte skillId;
    private final int maxComboSize;
    private final int timeLimit;
    private int comboTimer = 0;
    private boolean isFinished = false;
    private final List<Float> damageList = new ArrayList<Float>();
    private float comboDamage = 0.0f;
    private Entity lastEntityHit = null;
    private int entityId;
    private int consecutiveHits = 0;

    public Combo(EntityPlayer player, SkillBase skill, int maxComboSize, int timeLimit) {
        this(skill.getId(), maxComboSize, timeLimit);
        if (player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
        }
    }

    private Combo(byte skillId, int maxComboSize, int timeLimit) {
        this.skillId = skillId;
        this.maxComboSize = maxComboSize;
        this.timeLimit = timeLimit;
    }

    public byte getSkillId() {
        return this.skillId;
    }

    public int getNumHits() {
        return this.damageList.size();
    }

    public int getMaxNumHits() {
        return this.maxComboSize;
    }

    public float getDamage() {
        return this.comboDamage;
    }

    public List<Float> getDamageList() {
        return Collections.unmodifiableList(this.damageList);
    }

    public Entity getLastEntityHit() {
        return this.lastEntityHit;
    }

    public int getConsecutiveHits() {
        return this.consecutiveHits;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public String getLabel() {
        return StatCollector.func_74838_a((String)("combo.label." + Math.min(this.getNumHits(), 10)));
    }

    public void onUpdate(EntityPlayer player) {
        if (this.comboTimer > 0) {
            --this.comboTimer;
            if (this.comboTimer == 0) {
                this.endCombo(player);
            }
        }
    }

    public void add(EntityPlayer player, Entity target, float damage) {
        if (this.getNumHits() < this.maxComboSize && (this.comboTimer > 0 || this.getNumHits() == 0)) {
            if (target != null && target == this.lastEntityHit) {
                ++this.consecutiveHits;
            } else {
                this.lastEntityHit = target;
                this.consecutiveHits = target != null ? 1 : 0;
            }
            this.damageList.add(Float.valueOf(damage));
            this.comboDamage += damage;
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
            }
            if (this.getNumHits() == this.maxComboSize) {
                this.endCombo(player);
            } else {
                this.comboTimer = this.timeLimit;
            }
        } else {
            this.endCombo(player);
        }
    }

    public void addDamageOnly(EntityPlayer player, float damage) {
        if (!this.isFinished()) {
            this.comboDamage += damage;
            if (this.getNumHits() == 0) {
                this.comboTimer = this.timeLimit;
            }
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
            }
        }
    }

    public void endCombo(EntityPlayer player) {
        if (!this.isFinished) {
            this.isFinished = true;
            this.lastEntityHit = null;
            this.consecutiveHits = 0;
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getEntityFromWorld(World world) {
        this.lastEntityHit = world.func_73045_a(this.entityId);
    }

    public final NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("SkillID", this.skillId);
        compound.func_74768_a("MaxSize", this.maxComboSize);
        compound.func_74768_a("TimeLimit", this.timeLimit);
        compound.func_74768_a("CurrentSize", this.getNumHits());
        for (int i = 0; i < this.getNumHits(); ++i) {
            compound.func_74776_a("Dmg" + i, this.damageList.get(i).floatValue());
        }
        compound.func_74776_a("TotalDamage", this.comboDamage);
        compound.func_74768_a("EntityId", this.lastEntityHit != null ? this.lastEntityHit.func_145782_y() : 0);
        compound.func_74768_a("ConsecutiveHits", this.consecutiveHits);
        compound.func_74757_a("Finished", this.isFinished);
        return compound;
    }

    public static final Combo readFromNBT(NBTTagCompound compound) {
        Combo combo = new Combo(compound.func_74771_c("SkillID"), compound.func_74762_e("MaxSize"), compound.func_74762_e("TimeLimit"));
        int size = compound.func_74762_e("CurrentSize");
        for (int i = 0; i < size; ++i) {
            combo.damageList.add(Float.valueOf(compound.func_74760_g("Dmg" + i)));
        }
        combo.comboDamage = compound.func_74760_g("TotalDamage");
        combo.entityId = compound.func_74762_e("EntityId");
        combo.consecutiveHits = compound.func_74762_e("ConsecutiveHits");
        combo.isFinished = compound.func_74767_n("Finished");
        return combo;
    }
}

