/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.api.IDashItem;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.server.DashImpactPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Dash
extends SkillActive {
    public static final double BASE_MOVE = (double)0.1f;
    private boolean isActive = false;
    private int activeTime;
    private Vec3 trajectory;
    private Vec3 initialPosition;
    private Entity target;
    private int impactTime;

    public Dash(String translationKey) {
        super(translationKey);
    }

    private Dash(Dash skill) {
        super(skill);
    }

    @Override
    public Dash newInstance() {
        return new Dash(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.getDamage(), false));
        desc.add(StatCollector.func_74837_a((String)(this.getTranslationKey() + ".info.knockback"), (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.getKnockback()))}));
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(StatCollector.func_74837_a((String)(this.getTranslationKey() + ".info.min_range"), (Object[])new Object[]{String.format("%.1f", this.getMinDistance())}));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.isActive || this.impactTime > 0;
    }

    protected int getMaxActiveTime() {
        return 14 + 2 * this.level;
    }

    private int getBlockCooldown() {
        return 30 - 2 * this.level;
    }

    @Override
    protected float getExhaustion() {
        return 1.0f - 0.05f * (float)this.level;
    }

    private int getDamage() {
        return 2 + this.level;
    }

    private float getKnockback() {
        return 0.4f * (float)this.level;
    }

    private double getRange() {
        return 3.0 + (double)this.level;
    }

    private double getMinDistance() {
        return 2.0 - 0.2 * (double)this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && this.canHeldItemDash(player);
    }

    private boolean canHeldItemDash(EntityPlayer player) {
        if (PlayerUtils.isBlocking(player)) {
            return true;
        }
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof IDashItem) {
            return player.func_71039_bw();
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.field_70122_E && this.canUse(player) && Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key, boolean isLockedOn) {
        if (Config.requiresLockOn() && !isLockedOn) {
            return false;
        }
        return key == mc.field_71474_y.field_74312_F;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        return this.canExecute(player) && this.activate(player);
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.isActive = true;
        this.activeTime = 0;
        player.func_70031_b(true);
        this.trajectory = player.func_70040_Z();
        this.initialPosition = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.initialPosition = null;
        this.impactTime = 0;
        this.setNotDashing(player);
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.impactTime > 0) {
            --this.impactTime;
            if (this.impactTime == 0) {
                this.target = null;
            }
        }
        if (this.isActive) {
            player.func_70031_b(true);
            if (!this.canHeldItemDash(player)) {
                if (!player.field_70170_p.field_72995_K) {
                    this.deactivate(player);
                }
            } else if (player.field_70170_p.field_72995_K) {
                MovingObjectPosition mop;
                if (this.trajectory != null) {
                    double bonus = 1.0 + 0.1 * (double)this.level;
                    double speed = bonus * player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                    if (player.func_70090_H() || player.func_70058_J()) {
                        speed *= 0.15;
                    }
                    if (player.field_70122_E) {
                        this.trajectory = player.func_70040_Z();
                    }
                    player.func_70024_g(this.trajectory.field_72450_a * speed, -0.02, this.trajectory.field_72449_c * speed);
                }
                if ((mop = TargetUtils.checkForImpact(player.field_70170_p, (Entity)player, (Entity)player, 0.5, false)) != null || player.field_70123_F) {
                    PacketDispatcher.sendToServer(new DashImpactPacket(player, mop));
                    DSSPlayerInfo.get(player).setUseItemCooldown(this.getBlockCooldown());
                    KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151463_i(), (boolean)false);
                    this.impactTime = 5;
                    if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                        this.target = mop.field_72308_g;
                    }
                    double d = player.field_70122_E ? 2.0 : 0.5;
                    double dy = player.field_70122_E ? 0.3 : -0.15;
                    player.func_70016_h(-player.field_70159_w * d, dy, -player.field_70179_y * d);
                    this.setNotDashing(player);
                } else if (this.initialPosition == null || player.func_70011_f(this.initialPosition.field_72450_a, this.initialPosition.field_72448_b, this.initialPosition.field_72449_c) > this.getRange()) {
                    player.func_70024_g(-player.field_70159_w * 0.5, -0.02, -player.field_70179_y * 0.5);
                    this.deactivate(player);
                } else if (!Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d()) {
                    this.deactivate(player);
                }
            }
        }
        if (this.isActive) {
            ++this.activeTime;
            if (this.activeTime > this.getMaxActiveTime() && !player.field_70170_p.field_72995_K) {
                this.deactivate(player);
            }
        }
    }

    public void onImpact(World world, EntityPlayer player, MovingObjectPosition mop) {
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            this.target = mop.field_72308_g;
            double distance = this.target.func_70011_f(this.initialPosition.field_72450_a, this.initialPosition.field_72448_b, this.initialPosition.field_72449_c);
            double bbMod = this.target.field_70130_N / 2.0f + player.field_70130_N / 2.0f;
            double speed = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            double sf = 1.0 + (speed - (double)0.1f);
            if (player.func_70090_H() || player.func_70058_J()) {
                sf *= 0.3;
            }
            if (speed > 0.075 && distance - bbMod > this.getMinDistance() && distance < this.getRange() + 1.0 && player.func_70068_e(this.target) < 6.0) {
                float dmg = (float)(sf * (double)this.getDamage() * distance / this.getRange());
                this.impactTime = 5;
                this.target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), dmg);
                if (this.target instanceof EntityLivingBase) {
                    float db = 0.15f * (float)(distance - this.getMinDistance());
                    float k = (float)sf * Math.min(db + this.getKnockback(), 3.0f);
                    TargetUtils.knockTargetBack((EntityLivingBase)this.target, (EntityLivingBase)player, 0.5f * k);
                }
                if (this.target instanceof EntityPlayerMP && !player.field_70170_p.field_72995_K) {
                    ((EntityPlayerMP)this.target).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(this.target));
                }
            }
        }
        DSSPlayerInfo.get(player).setUseItemCooldown(this.getBlockCooldown());
        PlayerUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "dynamicswordskills:slam", 0.4f, 0.5f);
        this.setNotDashing(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.isActive;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        player.func_70031_b(true);
        return false;
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (this.impactTime > 0 && source.func_76346_g() == this.target) {
            return true;
        }
        return source.field_76373_n.equals("mob") && source.func_76346_g() != null && player.func_70068_e(source.func_76346_g()) < 6.0;
    }

    private void setNotDashing(EntityPlayer player) {
        this.isActive = false;
        player.func_70031_b(false);
        this.trajectory = null;
        if (!this.isActive()) {
            this.target = null;
        }
    }
}

