/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.api.SkillGroup;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.client.MortalDrawPacket;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.Skills;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class MortalDraw
extends SkillActive {
    private static final int DELAY = 30;
    private int attackTimer;
    private int swordSlot;
    private Entity target;

    public MortalDraw(String translationKey) {
        super(translationKey);
    }

    private MortalDraw(MortalDraw skill) {
        super(skill);
    }

    @Override
    public MortalDraw newInstance() {
        return new MortalDraw(this);
    }

    @Override
    public boolean displayInGroup(SkillGroup group) {
        return super.displayInGroup(group) || group == Skills.SWORD_GROUP || group == Skills.TARGETED_GROUP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(100, true) + "%");
        desc.add(this.getTimeLimitDisplay(this.getAttackTime() - 30));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.attackTimer > 28;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.attackTimer > 25;
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - 0.2f * (float)this.level;
    }

    private int getAttackTime() {
        return this.level + 30 + 2;
    }

    private int getDamageMultiplier() {
        return 100 + 10 * this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        this.swordSlot = -1;
        if (super.canUse(player) && player.func_70694_bm() == null && this.attackTimer == 0) {
            this.swordSlot = MortalDraw.getSwordSlot(player);
        }
        return this.swordSlot > -1;
    }

    public static int getSwordSlot(EntityPlayer player) {
        byte plvl = DSSPlayerInfo.get(player).getTrueSkillLevel(Skills.mortalDraw);
        boolean needsDummy = DSSPlayerInfo.get(player).getTrueSkillLevel(Skills.swordBasic) < 1;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || (plvl <= 0 || !PlayerUtils.isSword(stack)) && !PlayerUtils.isProvider(stack, Skills.mortalDraw) || needsDummy && !PlayerUtils.isProvider(stack, Skills.swordBasic)) continue;
            return i;
        }
        return -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.func_70694_bm() == null && Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key, boolean isLockedOn) {
        if (!isLockedOn) {
            return false;
        }
        return key == mc.field_71474_y.field_74312_F;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        return this.canExecute(player) && this.activate(player);
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.attackTimer = this.getAttackTime();
        this.target = null;
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.attackTimer = 0;
        this.swordSlot = -1;
        this.target = null;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.attackTimer > 0) {
            --this.attackTimer;
            if (this.attackTimer == 30 && !player.field_70170_p.field_72995_K && player.func_70694_bm() == null) {
                this.drawSword(player, null);
                if (player.func_70694_bm() != null) {
                    PacketDispatcher.sendTo(new MortalDrawPacket(), (EntityPlayerMP)player);
                }
            }
        }
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (!player.field_70170_p.field_72995_K && source.func_76346_g() != null) {
            if (this.target == source.func_76346_g()) {
                return true;
            }
            if (this.attackTimer > 30) {
                if (this.drawSword(player, source.func_76346_g())) {
                    PacketDispatcher.sendTo(new MortalDrawPacket(), (EntityPlayerMP)player);
                    this.target = source.func_76346_g();
                    return true;
                }
                this.attackTimer = 30;
                this.target = null;
            }
        }
        return false;
    }

    @Override
    public float onImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        if (this.attackTimer > 30) {
            this.attackTimer = 30;
            PlayerUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "dynamicswordskills:mortaldraw", 0.4f, 0.5f);
            return amount * (1.0f + (float)this.getDamageMultiplier() / 100.0f);
        }
        this.target = null;
        return amount;
    }

    public boolean drawSword(EntityPlayer player, Entity attacker) {
        boolean flag = false;
        if (this.swordSlot > -1 && this.swordSlot != player.field_71071_by.field_70461_c && player.func_70694_bm() == null) {
            ItemStack sword = player.field_71071_by.func_70301_a(this.swordSlot);
            if (!player.field_70170_p.field_72995_K) {
                player.field_71071_by.func_70299_a(this.swordSlot, null);
            }
            player.func_70062_b(0, sword);
            player.func_110140_aT().func_111147_b(sword.func_111283_C());
            ILockOnTarget skill = DSSPlayerInfo.get(player).getTargetingSkill();
            flag = skill != null && skill.getCurrentTarget() == attacker;
        }
        this.swordSlot = -1;
        return flag;
    }
}

