/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.api.SkillGroup;
import dynamicswordskills.client.DSSClientEvents;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.Skills;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class RisingCut
extends SkillActive {
    private int ticksTilFail;
    private int activeTimer;
    private int animationTimer;
    private Entity entityHit;
    private boolean hitEntity;

    public RisingCut(String translationKey) {
        super(translationKey);
    }

    private RisingCut(RisingCut skill) {
        super(skill);
    }

    @Override
    public RisingCut newInstance() {
        return new RisingCut(this);
    }

    @Override
    public boolean displayInGroup(SkillGroup group) {
        return super.displayInGroup(group) || group == Skills.SWORD_GROUP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getRangeDisplay(4 + this.level / 2));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    public boolean isAnimating() {
        return this.animationTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - (float)this.level * 0.2f;
    }

    protected double getMotionY() {
        return 0.4 + 0.065 * (double)this.level;
    }

    private void jump(EntityPlayer player) {
        player.field_70181_x += this.getMotionY();
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity((Entity)player));
        }
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && !player.func_71039_bw() && PlayerUtils.isSwordOrProvider(player.func_70694_bm(), this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.ticksTilFail > 0 && player.field_70181_x > 0.0 && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key, boolean isLockedOn) {
        if (Config.requiresLockOn() && !isLockedOn) {
            return false;
        }
        return key == mc.field_71474_y.field_74314_A || key == mc.field_71474_y.field_74312_F;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == mc.field_71474_y.field_74314_A) {
            if (player.field_70122_E && this.ticksTilFail == 0 && !this.isActive() && !player.func_71039_bw() && player.func_70093_af()) {
                this.ticksTilFail = 3;
            }
        } else if (this.canExecute(player) && this.activate(player)) {
            DSSClientEvents.handlePlayerAttack(mc);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.activeTimer = 20 + 3 * this.level;
        this.animationTimer = 5 + this.level;
        this.entityHit = null;
        this.hitEntity = false;
        if (!player.field_70170_p.field_72995_K && Config.canHighJump()) {
            this.jump(player);
        }
        return this.isActive();
    }

    private boolean canAttack(EntityLivingBase entity) {
        return !(entity instanceof EntityPlayer) || !PlayerUtils.isBlocking((EntityPlayer)entity);
    }

    @Override
    public boolean onAttack(EntityPlayer player, EntityLivingBase entity, DamageSource source, float amount) {
        if (!this.hitEntity && this.canAttack(entity)) {
            this.hitEntity = true;
            if (!player.field_70170_p.field_72995_K && !Config.canHighJump()) {
                this.jump(player);
            }
        }
        return false;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.activeTimer = 0;
        this.animationTimer = 0;
        this.hitEntity = false;
        this.entityHit = null;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.ticksTilFail > 0) {
            --this.ticksTilFail;
        }
        if (this.animationTimer > 0) {
            --this.animationTimer;
        }
        if (this.activeTimer > 0) {
            --this.activeTimer;
            if (player.field_70122_E) {
                if (!player.field_70170_p.field_72995_K && (this.hitEntity || Config.canHighJump())) {
                    this.deactivate(player);
                }
            } else if (this.entityHit != null) {
                if (!this.entityHit.field_70128_L) {
                    double resist = 1.0;
                    if (this.entityHit instanceof EntityLivingBase) {
                        resist = 1.0 - ((EntityLivingBase)this.entityHit).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
                    }
                    double dy = this.getMotionY() * resist;
                    this.entityHit.func_70024_g(0.0, dy, 0.0);
                    if (this.entityHit instanceof EntityPlayerMP && !player.field_70170_p.field_72995_K) {
                        ((EntityPlayerMP)this.entityHit).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(this.entityHit));
                    }
                }
                this.entityHit = null;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        player.field_70733_aJ = 0.5f;
        return false;
    }

    @Override
    public void postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        if (this.canAttack(entity)) {
            this.entityHit = entity;
        }
    }

    @Override
    public boolean onFall(EntityPlayer player, LivingFallEvent event) {
        if (this.isActive() && (this.hitEntity || Config.canHighJump())) {
            event.distance -= 1.0f + (float)this.level;
            this.onDeactivated(player.field_70170_p, player);
        }
        return false;
    }
}

