/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.network.bidirectional.DeactivateSkillPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.IModifiableSkill;
import dynamicswordskills.skills.ISkillModifier;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;

public abstract class SkillActive
extends SkillBase {
    public SkillActive(String translationKey) {
        super(translationKey);
    }

    protected SkillActive(SkillActive skill) {
        super(skill);
    }

    @Override
    public String getActivationDisplay() {
        return StatCollector.func_74838_a((String)(this.getTranslationKey() + ".activation"));
    }

    protected boolean allowUserActivation() {
        return true;
    }

    public abstract boolean isActive();

    protected abstract float getExhaustion();

    protected boolean autoAddExhaustion() {
        return true;
    }

    @Override
    protected void resetModifiers(EntityPlayer player) {
    }

    public boolean canUse(EntityPlayer player) {
        return this.level > 0 && (player.field_71075_bZ.field_75098_d || player.func_71024_bL().func_75116_a() > 0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key, boolean isLockedOn) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressedWhileAnimating(Minecraft mc, KeyBinding key, EntityPlayer player) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void keyReleased(Minecraft mc, KeyBinding key, EntityPlayer player) {
    }

    protected boolean sendClientUpdate() {
        return true;
    }

    protected abstract boolean onActivated(World var1, EntityPlayer var2);

    protected abstract void onDeactivated(World var1, EntityPlayer var2);

    public final boolean activate(EntityPlayer player) {
        if (Config.isSkillDisabled(player, this) || !this.allowUserActivation()) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this, false));
            if (this.sendClientUpdate()) {
                return true;
            }
        }
        return DSSPlayerInfo.get(player).activateSkill(this, false);
    }

    public final void deactivate(EntityPlayer player) throws IllegalStateException {
        if (this.isActive()) {
            this.onDeactivated(player.field_70170_p, player);
            if (this.isActive()) {
                DynamicSwordSkills.logger.error(this.getDisplayName() + " is still active after onDeactivated called - this may result in SEVERE errors or even crashes!!!");
            } else if (player.field_70170_p.field_72995_K) {
                PacketDispatcher.sendToServer(new DeactivateSkillPacket(this));
            } else {
                PacketDispatcher.sendTo(new DeactivateSkillPacket(this), (EntityPlayerMP)player);
            }
        }
    }

    public final <T extends SkillActive> boolean trigger(World world, EntityPlayer player, boolean wasTriggered) {
        if (Config.isSkillDisabled(player, this)) {
            if (!world.field_72995_K) {
                PacketDispatcher.sendTo(new DeactivateSkillPacket(this), (EntityPlayerMP)player);
            }
            PlayerUtils.sendTranslatedChat(player, "chat.dss.skill.use.disabled", new ChatComponentTranslation(this.getNameTranslationKey(), new Object[0]));
        } else if (wasTriggered || this.allowUserActivation()) {
            if (this.canUse(player)) {
                if (this.autoAddExhaustion() && !player.field_71075_bZ.field_75098_d) {
                    player.func_71020_j(this.getExhaustion());
                }
                if (!world.field_72995_K && this.sendClientUpdate()) {
                    PacketDispatcher.sendTo(new ActivateSkillPacket(this, wasTriggered), (EntityPlayerMP)player);
                }
                if (this.onActivated(world, player)) {
                    if (this instanceof IModifiableSkill) {
                        SkillActive.applyActivationSkillModifiers(this, player);
                    }
                    this.postActivated(player);
                    return true;
                }
            } else if (this.level > 0) {
                PlayerUtils.sendTranslatedChat(player, "chat.dss.skill.use.fail", new ChatComponentTranslation(this.getNameTranslationKey(), new Object[0]));
            }
        }
        return false;
    }

    protected void postActivated(EntityPlayer player) {
    }

    protected static <T extends SkillActive, M extends SkillBase> void applyActivationSkillModifiers(T parent, EntityPlayer player) {
        DSSPlayerInfo skills = DSSPlayerInfo.get(player);
        for (SkillBase t : ((IModifiableSkill)((Object)parent)).getSkillModifiers()) {
            SkillBase instance;
            if (Config.isSkillDisabled(player, t) || !((instance = skills.getPlayerSkill(t)) instanceof ISkillModifier) || instance.getLevel() <= 0 || !((ISkillModifier)((Object)instance)).applyOnActivated(player)) continue;
            ((IModifiableSkill)((Object)parent)).applySkillModifier(instance, player);
        }
    }

    public boolean hasAnimation() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.isActive();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        return false;
    }

    public boolean onAttack(EntityPlayer player, EntityLivingBase entity, DamageSource source, float amount) {
        return false;
    }

    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        return false;
    }

    public float onImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        return amount;
    }

    public void postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
    }

    public boolean onFall(EntityPlayer player, LivingFallEvent event) {
        return false;
    }

    public boolean onCreativeFall(EntityPlayer player, PlayerFlyableFallEvent event) {
        return false;
    }
}

