/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.common.FMLContainer;
import cpw.mods.fml.common.InjectedModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.api.SkillGroup;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.client.SyncSkillPacket;
import dynamicswordskills.ref.Config;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public abstract class SkillBase {
    public static final byte MAX_LEVEL = 5;
    private ResourceLocation registryName = null;
    public static final ResourceLocation DEFAULT_ICON = new ResourceLocation("dynamicswordskills", "textures/skills/default.png");
    private ResourceLocation iconLocation = null;
    private int iconResolution = 16;
    public final String translationKey;
    private byte id;
    protected byte level = 0;
    private final List<IChatComponent> tooltip = new ArrayList<IChatComponent>();

    public SkillBase(String translationKey) {
        this.translationKey = translationKey;
    }

    protected SkillBase(SkillBase skill) {
        this.id = skill.id;
        this.iconLocation = skill.iconLocation;
        this.registryName = skill.registryName;
        this.translationKey = skill.translationKey;
        this.tooltip.addAll(skill.tooltip);
    }

    public SkillBase register(String registryName) {
        this.setRegistryName(registryName);
        return SkillRegistry.register(this);
    }

    public final SkillBase onRegistered() {
        this.id = (byte)SkillRegistry.getSkillId(this);
        return this;
    }

    public SkillBase setRegistryName(String name) {
        String prefix;
        if (this.getRegistryName() != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
        }
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index);
        name = index == -1 ? name : name.substring(index + 1);
        ModContainer mc = Loader.instance().activeModContainer();
        String string = prefix = mc == null || mc instanceof InjectedModContainer && ((InjectedModContainer)mc).wrappedContainer instanceof FMLContainer ? "dynamicswordskills" : mc.getModId().toLowerCase();
        if (!oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
            DynamicSwordSkills.logger.warn("Dangerous alternative prefix `%s` for name `%s`, expected `%s` invalid registry invocation/invalid name?", new Object[]{oldPrefix, name, prefix});
            prefix = oldPrefix;
        }
        this.registryName = new ResourceLocation(prefix, name);
        return this;
    }

    public SkillBase setRegistryName(ResourceLocation name) {
        return this.setRegistryName(name.toString());
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public static final SkillBase getSkillFromItem(ItemStack stack, ISkillProvider item) {
        SkillBase skill = SkillRegistry.getSkillById(item.getSkillId(stack));
        return SkillBase.createLeveledSkill(skill, item.getSkillLevel(stack));
    }

    public static final SkillBase createLeveledSkill(@Nullable SkillBase skill, byte level) {
        if (skill != null && level > 0) {
            SkillBase instance = skill.newInstance();
            instance.level = level > skill.getMaxLevel() ? skill.getMaxLevel() : level;
            return instance;
        }
        return null;
    }

    public int hashCode() {
        return 31 * (31 + this.id) + this.level;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SkillBase skill = (SkillBase)obj;
        return skill.id == this.id && skill.level == this.level;
    }

    public boolean is(@Nullable SkillBase skill) {
        return skill != null && this.getId() == skill.getId();
    }

    public abstract SkillBase newInstance();

    public String getDisplayName() {
        return StatCollector.func_74837_a((String)this.getNameTranslationKey(), (Object[])new Object[0]);
    }

    public String getTranslationKey() {
        return "skill.dss." + this.translationKey;
    }

    public String getNameTranslationKey() {
        return this.getTranslationKey() + ".name";
    }

    public boolean displayInGroup(SkillGroup group) {
        return this.getRegistryName() != null && group.label.equalsIgnoreCase(this.getRegistryName().func_110624_b());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showIconIfUnknown(EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showNameIfUnknown(EntityPlayer player) {
        return false;
    }

    public ResourceLocation getIconLocation() {
        return this.iconLocation == null ? DEFAULT_ICON : this.iconLocation;
    }

    public SkillBase setIconLocation(String location) {
        this.iconLocation = DynamicSwordSkills.getResourceLocation(location);
        return this;
    }

    public int getIconResolution() {
        return this.iconResolution;
    }

    public SkillBase setIconResolution(int resolution) {
        this.iconResolution = resolution;
        return this;
    }

    public final byte getId() {
        return this.id;
    }

    public final byte getLevel() {
        return this.level;
    }

    public byte getMaxLevel() {
        return 5;
    }

    protected final SkillBase addDefaultTooltip() {
        return this.addTranslatedTooltip(this.getTranslationKey() + ".tooltip");
    }

    protected final SkillBase addTranslatedTooltip(String translationKey) {
        return this.addTooltip((IChatComponent)new ChatComponentTranslation(translationKey, new Object[0]));
    }

    protected final SkillBase addTooltip(IChatComponent component) {
        this.tooltip.add(component);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public final List<String> getTooltip(EntityPlayer player, boolean advanced) {
        ArrayList<String> desc = new ArrayList<String>(this.tooltip.size());
        for (IChatComponent s : this.tooltip) {
            desc.add(s.func_150260_c());
        }
        if (advanced) {
            this.addInformation(desc, player);
        }
        return desc;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
    }

    @Nullable
    public String getActivationDisplay() {
        return null;
    }

    public String getAreaDisplay(double area) {
        return StatCollector.func_74837_a((String)"skill.dss.info.area", (Object[])new Object[]{String.format("%.1f", area)});
    }

    public String getChargeDisplay(int chargeTime) {
        return StatCollector.func_74837_a((String)"skill.dss.info.charge", (Object[])new Object[]{chargeTime});
    }

    public String getDamageDisplay(float damage, boolean displayPlus) {
        return StatCollector.func_74837_a((String)"skill.dss.info.damage", (Object[])new Object[]{displayPlus ? "+" : "", String.format("%.1f", Float.valueOf(damage))});
    }

    public String getDamageDisplay(int damage, boolean displayPlus) {
        return StatCollector.func_74837_a((String)"skill.dss.info.damage", (Object[])new Object[]{displayPlus ? "+" : "", damage});
    }

    public String getDurationDisplay(int duration, boolean inTicks) {
        String time = inTicks ? StatCollector.func_74838_a((String)"skill.dss.ticks") : StatCollector.func_74838_a((String)"skill.dss.seconds");
        return StatCollector.func_74837_a((String)"skill.dss.info.duration", (Object[])new Object[]{inTicks ? duration : duration / 20, time});
    }

    public String getExhaustionDisplay(float exhaustion) {
        return StatCollector.func_74837_a((String)"skill.dss.info.exhaustion", (Object[])new Object[]{String.format("%.2f", Float.valueOf(exhaustion))});
    }

    public String getFullDescription() {
        return StatCollector.func_74838_a((String)(this.getTranslationKey() + ".description"));
    }

    public String getLevelDisplay(boolean simpleMax) {
        if (simpleMax && this.level == this.getMaxLevel()) {
            return StatCollector.func_74838_a((String)"skill.dss.level.max");
        }
        return StatCollector.func_74837_a((String)"skill.dss.info.level", (Object[])new Object[]{this.level, this.getMaxLevel()});
    }

    public String getRangeDisplay(double range) {
        return StatCollector.func_74837_a((String)"skill.dss.info.range", (Object[])new Object[]{String.format("%.1f", range)});
    }

    public String getTimeLimitDisplay(int time) {
        return StatCollector.func_74837_a((String)"skill.dss.info.time", (Object[])new Object[]{time});
    }

    protected boolean canIncreaseLevel(EntityPlayer player, int targetLevel) {
        return this.level + 1 == targetLevel && targetLevel <= this.getMaxLevel();
    }

    protected void levelUp(EntityPlayer player) {
        this.resetModifiers(player);
    }

    protected abstract void resetModifiers(EntityPlayer var1);

    public final void validateSkill(EntityPlayer player) {
        byte lvl = this.level;
        if (Config.isSkillDisabled(player, this)) {
            this.level = 0;
        }
        this.resetModifiers(player);
        this.level = lvl;
    }

    public final boolean grantSkill(EntityPlayer player) {
        return this.grantSkill(player, this.level + 1);
    }

    public final boolean grantSkill(EntityPlayer player, int targetLevel) {
        if (!Config.isSkillAllowed(this)) {
            return false;
        }
        if (targetLevel <= this.level || targetLevel > this.getMaxLevel()) {
            return false;
        }
        byte oldLevel = this.level;
        while (this.level < targetLevel && this.canIncreaseLevel(player, this.level + 1)) {
            this.level = (byte)(this.level + 1);
            this.levelUp(player);
        }
        if (Config.isSkillDisabled(player, this)) {
            this.validateSkill(player);
        }
        if (!player.field_70170_p.field_72995_K && oldLevel < this.level) {
            PacketDispatcher.sendTo(new SyncSkillPacket(this), (EntityPlayerMP)player);
        }
        return oldLevel < this.level;
    }

    public void onUpdate(EntityPlayer player) {
    }

    public final NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeAdditionalData(tag);
        tag.func_74778_a("id", this.getRegistryName().toString());
        tag.func_74774_a("level", this.level);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.level = tag.func_74771_c("level");
        this.readAdditionalData(tag);
    }

    public void writeAdditionalData(NBTTagCompound tag) {
    }

    public void readAdditionalData(NBTTagCompound tag) {
    }

    public static final SkillBase loadFromNBT(NBTTagCompound tag) {
        SkillBase skill = null;
        if (tag.func_150297_b("id", 1)) {
            skill = SkillRegistry.getSkillById(tag.func_74771_c("id"));
        } else {
            String name = tag.func_74779_i("id");
            if (name.lastIndexOf(58) == -1) {
                name = "dynamicswordskills:" + name;
            }
            skill = SkillRegistry.get(DynamicSwordSkills.getResourceLocation(name));
        }
        if (skill != null) {
            skill = skill.newInstance();
            skill.readFromNBT(tag);
        }
        return skill;
    }
}

