/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.SkillGroup;
import dynamicswordskills.client.DSSClientEvents;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.IComboSkill;
import dynamicswordskills.skills.IModifiableSkill;
import dynamicswordskills.skills.IReachAttackSkill;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.Skills;
import dynamicswordskills.skills.SuperSpinAttack;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SpinAttack
extends SkillActive
implements IModifiableSkill,
IReachAttackSkill {
    private int charge;
    private float currentSpin;
    private float arc;
    private int refreshed;
    @SideOnly(value=Side.CLIENT)
    private boolean clockwise;
    @SideOnly(value=Side.CLIENT)
    private List<EntityLivingBase> targets;
    private boolean isFlaming;
    private int superLevel;
    private float bonusRange;

    public SpinAttack(String translationKey) {
        super(translationKey);
    }

    private SpinAttack(SpinAttack skill) {
        super(skill);
    }

    @Override
    public SpinAttack newInstance() {
        return new SpinAttack(this);
    }

    @Override
    public boolean displayInGroup(SkillGroup group) {
        return super.displayInGroup(group) || group == Skills.WEAPON_GROUP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        this.superLevel = 0;
        this.bonusRange = 0.0f;
        SkillActive.applyActivationSkillModifiers(this, player);
        desc.add(this.getChargeDisplay(this.getChargeTime()));
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(StatCollector.func_74837_a((String)(this.getTranslationKey() + ".info.spins"), (Object[])new Object[]{this.superLevel + 1}));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.arc > 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.isActive() && !this.isCharging();
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - 0.2f * (float)this.level;
    }

    private int getChargeTime() {
        return 20 - this.level * 2;
    }

    private boolean isCharging() {
        return this.charge > 0;
    }

    private boolean canRefreshArc() {
        return this.refreshed < this.superLevel + 1 && this.arc == 360.0f * (float)this.refreshed;
    }

    private float getRange() {
        return 3.0f + (float)this.level * 0.3f + this.bonusRange;
    }

    private float getSpinSpeed() {
        return 120 + 3 * (this.superLevel + this.level);
    }

    protected boolean canSpin(EntityPlayer player) {
        return super.canUse(player) && !player.func_71039_bw() && PlayerUtils.isWeapon(player.func_70694_bm());
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return !this.isActive() && this.canSpin(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.canSpin(player);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isKeyPressed() {
        return DSSKeyHandler.keys[5].getIsKeyPressed() && DSSKeyHandler.keys[6].getIsKeyPressed() || Config.allowVanillaControls() && Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d() && Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key, boolean isLockedOn) {
        if (Config.requiresLockOn() && !isLockedOn) {
            return false;
        }
        return Config.allowVanillaControls() && (key == mc.field_71474_y.field_74370_x || key == mc.field_71474_y.field_74366_z) || key == DSSKeyHandler.keys[5].getKey() || key == DSSKeyHandler.keys[6].getKey();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (!this.isCharging() && this.isKeyPressed() && this.canSpin(player)) {
            this.clockwise = key == DSSKeyHandler.keys[6].getKey() || key == mc.field_71474_y.field_74366_z;
            this.charge = this.getChargeTime();
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.currentSpin = 0.0f;
        this.arc = 360.0f;
        this.refreshed = 0;
        this.superLevel = 0;
        this.bonusRange = 0.0f;
        this.isFlaming = EnchantmentHelper.func_90036_a((EntityLivingBase)player) > 0;
        return true;
    }

    @Override
    protected void postActivated(EntityPlayer player) {
        TargetUtils.applyExtendedReachModifier(player, this.getRange());
        IComboSkill combo = DSSPlayerInfo.get(player).getComboSkill();
        if (combo != null) {
            combo.setComboDamageOnlyMode(true);
        }
        this.startSpin(player);
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.charge = 0;
        this.currentSpin = 0.0f;
        this.arc = 0.0f;
        DSSPlayerInfo.get(player).setArmSwingProgress(0.0f, 0.0f);
        TargetUtils.removeExtendedReachModifier(player);
        IComboSkill combo = DSSPlayerInfo.get(player).getComboSkill();
        if (combo != null) {
            combo.setComboDamageOnlyMode(false);
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isCharging()) {
            if (player.field_70170_p.field_72995_K && this.canSpin(player) && this.isKeyPressed()) {
                --this.charge;
                int maxCharge = this.getChargeTime();
                if (this.charge < maxCharge) {
                    float f = 1.0f - 0.5f * ((float)(maxCharge - this.charge) / (float)maxCharge);
                    DSSPlayerInfo.get(player).setArmSwingProgress(f, f);
                }
                --this.charge;
                if (this.charge == 0 && this.canExecute(player)) {
                    this.activate(player);
                }
            } else {
                this.charge = 0;
                DSSPlayerInfo.get(player).setArmSwingProgress(0.0f, 0.0f);
            }
        } else if (this.isActive()) {
            if (player.field_70170_p.field_72995_K) {
                if (!PlayerUtils.isWeapon(player.func_70694_bm()) || !this.isKeyPressed()) {
                    this.deactivate(player);
                } else {
                    this.incrementSpin(player);
                }
            } else {
                this.incrementSpin(player);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        if (PlayerUtils.isWeapon(player.func_70694_bm())) {
            DirtyEntityAccessor.syncCurrentPlayItem(Minecraft.func_71410_x().field_71442_b);
            this.attackTargetsInSight(player);
            this.spawnParticles(player);
            DSSPlayerInfo.get(player).setArmSwingProgress(0.5f, 0.5f);
            float fps = 30.0f / (float)DynamicSwordSkills.proxy.getDebugFPS();
            float speed = fps * this.getSpinSpeed();
            player.func_70082_c(this.clockwise ? speed : -speed, 0.0f);
        }
        return true;
    }

    private void attackTargetsInSight(EntityPlayer player) {
        List<EntityLivingBase> list = TargetUtils.acquireAllLookTargets((EntityLivingBase)player, (int)(this.getRange() + 0.5f), 1.0, this.getTargetSelectors());
        for (EntityLivingBase target : list) {
            if (this.targets == null || !this.targets.contains(target)) continue;
            DSSClientEvents.multiAttack(Minecraft.func_71410_x(), (Entity)target, this);
            this.targets.remove(target);
        }
    }

    protected List<Predicate<Entity>> getTargetSelectors() {
        ArrayList list = Lists.newArrayList();
        list.add(TargetUtils.COLLIDABLE_ENTITY_SELECTOR);
        list.add(TargetUtils.NON_RIDING_SELECTOR);
        list.add(TargetUtils.NON_TEAM_SELECTOR);
        return list;
    }

    private void startSpin(EntityPlayer player) {
        ++this.refreshed;
        if (player.field_70170_p.field_72995_K) {
            this.targets = player.field_70170_p.func_72872_a(EntityLivingBase.class, player.field_70121_D.func_72314_b((double)this.getRange(), 0.0, (double)this.getRange()));
            if (this.targets.contains(player)) {
                this.targets.remove(player);
            }
        } else {
            PlayerUtils.playRandomizedSound(player, "dynamicswordskills:spinattack", 0.4f, 0.5f);
            if (this.refreshed > 1) {
                player.func_71020_j(this.getExhaustion());
            }
        }
    }

    private void incrementSpin(EntityPlayer player) {
        this.currentSpin = (float)((double)this.currentSpin + (double)this.getSpinSpeed() * 0.21);
        if (this.currentSpin >= this.arc) {
            this.deactivate(player);
        } else if (this.currentSpin > 360.0f * (float)this.refreshed) {
            this.startSpin(player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EntityPlayer player) {
        String particle = this.isFlaming ? "flame" : (this.superLevel > 0 ? "magicCrit" : "crit");
        Vec3 vec3 = player.func_70040_Z();
        double posX = player.field_70165_t + vec3.field_72450_a * (double)this.getRange();
        double posY = player.field_70163_u + (double)player.func_70047_e() - 0.1;
        double posZ = player.field_70161_v + vec3.field_72449_c * (double)this.getRange();
        for (int i = 0; i < 2; ++i) {
            player.field_70170_p.func_72869_a(particle, posX, posY, posZ, vec3.field_72450_a * 0.15, 0.01, vec3.field_72449_c * 0.15);
        }
    }

    @Override
    public double getAttackRange(EntityPlayer player) {
        return this.getRange();
    }

    @Override
    public <T extends SkillBase> Set<T> getSkillModifiers() {
        return Sets.newHashSet((Object[])new SkillBase[]{Skills.superSpinAttack});
    }

    @Override
    public <T extends SkillBase> void applySkillModifier(T modifier, EntityPlayer player) {
        if (this.currentSpin < 0.01f) {
            this.superLevel = modifier.getLevel();
            this.bonusRange = ((SuperSpinAttack)modifier).getRangeModifier();
        } else if (this.canRefreshArc() && this.canSpin(player)) {
            this.arc += 360.0f;
        }
    }
}

