/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.api.SkillGroup;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.Skills;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class SwordBreak
extends SkillActive {
    private int breakTimer;
    @SideOnly(value=Side.CLIENT)
    private int keysPressed;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private boolean playMissSound;

    public SwordBreak(String translationKey) {
        super(translationKey);
    }

    private SwordBreak(SwordBreak skill) {
        super(skill);
    }

    @Override
    public SwordBreak newInstance() {
        return new SwordBreak(this);
    }

    @Override
    public boolean displayInGroup(SkillGroup group) {
        return super.displayInGroup(group) || group == Skills.WEAPON_GROUP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.func_74837_a((String)(this.getTranslationKey() + ".info.durability"), (Object[])new Object[]{this.getMaxDamage()}));
        desc.add(StatCollector.func_74837_a((String)(this.getTranslationKey() + ".info.knockback"), (Object[])new Object[]{Float.valueOf(this.getKnockbackStrength())}));
        desc.add(this.getTimeLimitDisplay(this.getActiveTime() - this.getUseDelay()));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.breakTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    private int getActiveTime() {
        return 9 + this.level / 2;
    }

    private int getUseDelay() {
        return 5 - this.level / 2;
    }

    private int getMaxDamage() {
        return (this.level + 1) * 15;
    }

    public float getKnockbackStrength() {
        return 0.5f + 0.1f * (float)this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isWeapon(player.func_70694_bm()) && !player.func_71039_bw();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.canUse(player) && this.keysPressed > 1 && this.ticksTilFail > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key, boolean isLockedOn) {
        return !Config.requiresLockOn() || isLockedOn;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (Config.allowVanillaControls() && key == mc.field_71474_y.field_74351_w || key == DSSKeyHandler.keys[3].getKey()) {
            this.ticksTilFail = 6;
            if (this.keysPressed < 2) {
                if (!Config.requiresDoubleTap() && key == DSSKeyHandler.keys[3].getKey()) {
                    ++this.keysPressed;
                }
                ++this.keysPressed;
            }
        } else {
            if (key == mc.field_71474_y.field_74313_G) {
                boolean flag = this.canExecute(player) && this.activate(player);
                this.ticksTilFail = 0;
                this.keysPressed = 0;
                return flag;
            }
            this.ticksTilFail = 0;
            this.keysPressed = 0;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.breakTimer = this.getActiveTime();
        this.playMissSound = true;
        if (world.field_72995_K) {
            KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151463_i(), (boolean)false);
            player.func_71038_i();
        }
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.breakTimer = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            if (--this.breakTimer <= this.getUseDelay() && this.playMissSound) {
                this.playMissSound = false;
                PlayerUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "dynamicswordskills:swordmiss", 0.4f, 0.5f);
            }
        } else if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            --this.ticksTilFail;
            if (this.ticksTilFail < 1) {
                this.keysPressed = 0;
            }
        }
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (source.func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.func_76364_f();
            ItemStack stackToDamage = attacker.func_70694_bm();
            if (this.breakTimer > this.getUseDelay() && stackToDamage != null && PlayerUtils.isWeapon(player.func_70694_bm())) {
                this.breakTimer = this.getUseDelay();
                PlayerUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "dynamicswordskills:swordstrike", 0.4f, 0.5f);
                this.playMissSound = false;
                if (!player.field_70170_p.field_72995_K) {
                    int dmg = Math.max(this.getMaxDamage() / 3, player.field_70170_p.field_73012_v.nextInt(this.getMaxDamage()));
                    stackToDamage.func_77972_a(dmg, attacker);
                    if (stackToDamage.field_77994_a <= 0) {
                        player.field_70170_p.func_72956_a((Entity)attacker, "random.break", 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                        attacker.func_70062_b(0, null);
                    }
                }
                TargetUtils.knockTargetBack(attacker, (EntityLivingBase)player, this.getKnockbackStrength());
                return true;
            }
        }
        return false;
    }
}

