/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.util;

import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.api.IWeapon;
import dynamicswordskills.api.WeaponRegistry;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.PlaySoundPacket;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.Skills;
import java.util.Random;
import mods.battlegear2.api.core.IBattlePlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PlayerUtils {
    public static boolean isBlocking(EntityPlayer player) {
        if (player.func_70632_aY()) {
            return true;
        }
        if (DynamicSwordSkills.isBG2Enabled) {
            return ((IBattlePlayer)player).isBattlemode() && ((IBattlePlayer)player).isBlockingWithShield();
        }
        return false;
    }

    public static boolean isSword(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof IWeapon) {
            return ((IWeapon)stack.func_77973_b()).isSword(stack);
        }
        return WeaponRegistry.INSTANCE.isSword(stack.func_77973_b());
    }

    public static boolean isWeapon(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof IWeapon) {
            return ((IWeapon)stack.func_77973_b()).isWeapon(stack);
        }
        return PlayerUtils.isSword(stack) || WeaponRegistry.INSTANCE.isWeapon(stack.func_77973_b());
    }

    public static boolean isSwordOrProvider(ItemStack stack, SkillBase skill) {
        return PlayerUtils.isSword(stack) || PlayerUtils.isProvider(stack, skill);
    }

    public static boolean isProvider(ItemStack stack, SkillBase skill) {
        if (stack == null || !(stack.func_77973_b() instanceof ISkillProvider)) {
            return false;
        }
        if (((ISkillProvider)stack.func_77973_b()).getSkillId(stack) == skill.getId()) {
            return true;
        }
        return Skills.swordBasic.is(skill) && ((ISkillProvider)stack.func_77973_b()).grantsBasicSwordSkill(stack);
    }

    public static float getHealthMissing(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d ? 0.0f : player.func_110138_aP() - player.func_110143_aJ();
    }

    public static void sendTranslatedChat(EntityPlayer player, String message, Object ... args) {
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(message, args));
    }

    public static void playSound(EntityPlayer player, String sound, float volume, float pitch) {
        if (player.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToServer(new PlaySoundPacket(sound, volume, pitch, (Entity)player));
        } else {
            PacketDispatcher.sendTo(new PlaySoundPacket(sound, volume, pitch), (EntityPlayerMP)player);
        }
    }

    public static void playRandomizedSound(EntityPlayer player, String sound, float f, float add) {
        float volume = player.field_70170_p.field_73012_v.nextFloat() * f + add;
        float pitch = 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * f + add);
        PlayerUtils.playSound(player, sound, volume, pitch);
    }

    public static void playSoundAtEntity(World world, Entity entity, String sound, float f, float add) {
        float volume = world.field_73012_v.nextFloat() * f + add;
        float pitch = 1.0f / (world.field_73012_v.nextFloat() * f + add);
        world.func_72956_a(entity, sound, volume, pitch);
    }

    public static void spawnItemWithRandom(World world, ItemStack stack, double x, double y, double z) {
        if (!world.field_72995_K && stack != null) {
            double spawnX = x + (double)world.field_73012_v.nextFloat();
            double spawnY = y + (double)world.field_73012_v.nextFloat();
            double spawnZ = z + (double)world.field_73012_v.nextFloat();
            float f3 = 0.05f;
            EntityItem entityitem = new EntityItem(world, spawnX, spawnY, spawnZ, stack);
            entityitem.field_70159_w = (-0.5 + world.field_73012_v.nextGaussian()) * (double)f3;
            entityitem.field_70181_x = (4.0 + world.field_73012_v.nextGaussian()) * (double)f3;
            entityitem.field_70179_y = (-0.5 + world.field_73012_v.nextGaussian()) * (double)f3;
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void spawnXPOrbsWithRandom(World world, Random rand, int x, int y, int z, int xpAmount) {
        if (!world.field_72995_K) {
            while (xpAmount > 0) {
                int xp = xpAmount > 50 ? 50 : EntityXPOrb.func_70527_a((int)xpAmount);
                xpAmount -= xp;
                float spawnX = (float)x + rand.nextFloat();
                float spawnY = (float)y + rand.nextFloat();
                float spawnZ = (float)z + rand.nextFloat();
                EntityXPOrb xpOrb = new EntityXPOrb(world, (double)spawnX, (double)spawnY, (double)spawnZ, xp);
                xpOrb.field_70181_x += (4.0 + rand.nextGaussian()) * (double)0.05f;
                world.func_72838_d((Entity)xpOrb);
            }
        }
    }

    public static void dropHeldItem(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K && entity.func_70694_bm() != null) {
            EntityItem drop = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u - (double)0.3f + (double)entity.func_70047_e(), entity.field_70161_v, entity.func_70694_bm().func_77946_l());
            float f = 0.3f;
            float f1 = entity.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            drop.field_70159_w = -MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * f;
            drop.field_70179_y = MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * f;
            drop.field_70181_x = -MathHelper.func_76126_a((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f * entity.field_70170_p.field_73012_v.nextFloat();
            drop.field_70159_w += Math.cos(f1) * (double)f;
            drop.field_70181_x += (double)((entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
            drop.field_70179_y += Math.sin(f1) * (double)f;
            drop.field_145804_b = 40;
            entity.field_70170_p.func_72838_d((Entity)drop);
            entity.func_70062_b(0, (ItemStack)null);
        }
    }
}

