/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import cpw.mods.fml.relauncher.ReflectionHelper;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.core.proxy.Proxies;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;

public class AlleleEffectPotion
extends AlleleEffectThrottled {
    private final Potion potion;
    private final boolean isBadEffect;
    private final int duration;

    public AlleleEffectPotion(String name, boolean isDominant, Potion potion, int duration, boolean requiresWorking) {
        super(name, isDominant, 200, requiresWorking, false);
        this.potion = potion;
        this.isBadEffect = AlleleEffectPotion.isBadEffect(potion);
        this.duration = duration;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (this.isHalted(storedData, housing)) {
            return storedData;
        }
        AxisAlignedBB beatifyBox = this.getBounding(genome, housing, 1.0f);
        List list = housing.getWorld().func_72872_a(EntityPlayer.class, beatifyBox);
        for (Object entity : list) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)entity;
            int dur = this.duration;
            if (this.isBadEffect) {
                int count = ItemArmorApiarist.wearsItems((EntityPlayer)entity, this.getUID(), true);
                if (count >= 4) continue;
                if (count == 3) {
                    dur = this.duration / 4;
                } else if (count == 2) {
                    dur = this.duration / 2;
                } else if (count == 1) {
                    dur = this.duration * 3 / 4;
                }
            }
            player.func_70690_d(new PotionEffect(this.potion.func_76396_c(), dur, 0));
        }
        return storedData;
    }

    private static boolean isBadEffect(Potion potion) {
        try {
            return (Boolean)ReflectionHelper.getPrivateValue(Potion.class, (Object)potion, (String[])new String[]{"field_76418_K", "isBadEffect"});
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            Proxies.log.severe("Could not access potion field isBadEffect.");
            return false;
        }
    }
}

