/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.render.TextureManager;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public enum WoodType {
    LARCH,
    TEAK,
    ACACIA,
    LIME,
    CHESTNUT,
    WENGE,
    BAOBAB,
    SEQUOIA(4.0f),
    KAPOK,
    EBONY,
    MAHOGANY,
    BALSA(1.0f),
    WILLOW,
    WALNUT,
    GREENHEART(7.5f),
    CHERRY,
    MAHOE,
    POPLAR,
    PALM,
    PAPAYA,
    PINE(3.0f),
    PLUM,
    MAPLE,
    CITRUS,
    GIGANTEUM(2.0f),
    IPE,
    PADAUK,
    COCOBOLO,
    ZEBRAWOOD;

    public static final WoodType[] VALUES;
    private final float hardness;
    @SideOnly(value=Side.CLIENT)
    private static IIcon[][] icons;

    private WoodType() {
        this(2.0f);
    }

    private WoodType(float hardness) {
        this.hardness = hardness;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister register) {
        icons = new IIcon[3][VALUES.length];
        for (int i = 0; i < VALUES.length; ++i) {
            WoodType woodType = VALUES[i];
            String woodName = woodType.toString().toLowerCase(Locale.ENGLISH);
            WoodType.icons[0][i] = TextureManager.getInstance().registerTex(register, "wood/planks." + woodName);
            WoodType.icons[1][i] = TextureManager.getInstance().registerTex(register, "wood/bark." + woodName);
            WoodType.icons[2][i] = TextureManager.getInstance().registerTex(register, "wood/heart." + woodName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getPlankIcon() {
        return icons[0][this.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBarkIcon() {
        return icons[1][this.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getHeartIcon() {
        return icons[2][this.ordinal()];
    }

    public float getHardness() {
        return this.hardness;
    }

    public void saveToCompound(NBTTagCompound compound) {
        compound.func_74768_a("WoodType", this.ordinal());
    }

    public static WoodType getFromCompound(NBTTagCompound compound) {
        int typeOrdinal;
        if (compound != null && (typeOrdinal = compound.func_74762_e("WoodType")) < VALUES.length) {
            return VALUES[typeOrdinal];
        }
        return LARCH;
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    static {
        VALUES = WoodType.values();
    }
}

