/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.commands;

import forestry.api.arboriculture.ITreekeepingMode;
import forestry.core.commands.ICommandModeHelper;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import net.minecraft.world.World;

public class TreeModeHelper
implements ICommandModeHelper {
    @Override
    public String[] getModeNames() {
        ArrayList<ITreekeepingMode> treekeepingModes = PluginArboriculture.treeInterface.getTreekeepingModes();
        int modeStringCount = treekeepingModes.size();
        ArrayList<String> modeStrings = new ArrayList<String>(modeStringCount);
        for (ITreekeepingMode mode : treekeepingModes) {
            modeStrings.add(mode.getName());
        }
        return modeStrings.toArray(new String[modeStringCount]);
    }

    @Override
    public String getModeNameMatching(String desired) {
        ITreekeepingMode mode = PluginArboriculture.treeInterface.getTreekeepingMode(desired);
        if (mode == null) {
            return null;
        }
        return mode.getName();
    }

    @Override
    public String getModeName(World world) {
        return PluginArboriculture.treeInterface.getTreekeepingMode(world).getName();
    }

    @Override
    public void setMode(World world, String modeName) {
        PluginArboriculture.treeInterface.setTreekeepingMode(world, modeName);
    }

    @Override
    public Iterable<String> getDescription(String modeName) {
        ITreekeepingMode mode = PluginArboriculture.treeInterface.getTreekeepingMode(modeName);
        return mode.getDescription();
    }
}

