/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLog
extends Block
implements IWoodTyped {
    public static final short logsPerCat = 4;
    protected final LogCat cat;

    public BlockLog(LogCat cat) {
        this(cat, Material.field_151575_d);
    }

    protected BlockLog(LogCat cat, Material material) {
        super(material);
        this.cat = cat;
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149766_f);
        this.func_149647_a(Tabs.tabArboriculture);
    }

    public static int getTypeFromMeta(int damage) {
        return damage & 3;
    }

    public int func_149645_b() {
        return Blocks.field_150364_r.func_149645_b();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        int radius = 4;
        int boundary = radius + 1;
        if (world.func_72904_c(x - boundary, y - boundary, z - boundary, x + boundary, y + boundary, z + boundary)) {
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        Block neighbor = world.func_147439_a(x + i, y + j, z + k);
                        neighbor.beginLeavesDecay(world, x + i, y + j, z + k);
                    }
                }
            }
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        int type = BlockLog.getTypeFromMeta(meta);
        int b0 = 0;
        switch (side) {
            case 0: 
            case 1: {
                b0 = 0;
                break;
            }
            case 2: 
            case 3: {
                b0 = 8;
                break;
            }
            case 4: 
            case 5: {
                b0 = 4;
            }
        }
        return type | b0;
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        int totalWoods = WoodType.values().length;
        int count = Math.min(totalWoods - this.cat.ordinal() * 4, 4);
        for (int i = 0; i < count; ++i) {
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        WoodType.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int oriented = meta & 0xC;
        WoodType type = this.getWoodType(meta);
        if (type == null) {
            return null;
        }
        switch (oriented) {
            case 4: {
                if (side > 3) {
                    return type.getHeartIcon();
                }
                return type.getBarkIcon();
            }
            case 8: {
                if (side == 2 || side == 3) {
                    return type.getHeartIcon();
                }
                return type.getBarkIcon();
            }
        }
        if (side < 2) {
            return type.getHeartIcon();
        }
        return type.getBarkIcon();
    }

    public int func_149692_a(int meta) {
        return BlockLog.getTypeFromMeta(meta);
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)this, 1, BlockLog.getTypeFromMeta(meta));
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return this.getWoodType(world.func_72805_g(x, y, z)).getHardness();
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (face == ForgeDirection.DOWN) {
            return 20;
        }
        if (face != ForgeDirection.UP) {
            return 10;
        }
        return 5;
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    @Override
    public WoodType getWoodType(int meta) {
        int woodOrdinal = (meta = BlockLog.getTypeFromMeta(meta)) + this.cat.ordinal() * 4;
        if (woodOrdinal < WoodType.VALUES.length) {
            return WoodType.VALUES[woodOrdinal];
        }
        return null;
    }

    @Override
    public String getBlockKind() {
        return "log";
    }

    public static enum LogCat {
        CAT0,
        CAT1,
        CAT2,
        CAT3,
        CAT4,
        CAT5,
        CAT6,
        CAT7;

    }
}

