/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPlanks
extends Block
implements IWoodTyped {
    public static final int planksPerCat = 16;
    protected final PlankCat cat;

    public BlockPlanks(PlankCat cat) {
        this(cat, Material.field_151575_d);
    }

    protected BlockPlanks(PlankCat cat, Material material) {
        super(material);
        this.cat = cat;
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149766_f);
        this.func_149647_a(Tabs.tabArboriculture);
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        int totalWoods = WoodType.values().length;
        int count = Math.min(totalWoods - this.cat.ordinal() * 16, 16);
        for (int i = 0; i < count; ++i) {
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        WoodType.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        WoodType woodType = this.getWoodType(meta);
        if (woodType == null) {
            return null;
        }
        return woodType.getPlankIcon();
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return this.getWoodType(world.func_72805_g(x, y, z)).getHardness();
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 5;
    }

    @Override
    public WoodType getWoodType(int meta) {
        int woodOrdinal = this.cat.ordinal() * 16 + meta;
        if (woodOrdinal < WoodType.VALUES.length) {
            return WoodType.VALUES[woodOrdinal];
        }
        return null;
    }

    @Override
    public String getBlockKind() {
        return "planks";
    }

    public static enum PlankCat {
        CAT0,
        CAT1;

    }
}

