/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.google.common.collect.LinkedListMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import forestry.core.WorldGenerator;
import forestry.core.config.Config;
import forestry.core.interfaces.IResupplyHandler;
import forestry.core.utils.ChunkCoords;
import forestry.plugins.PluginManager;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;

public class TickHandlerCoreServer {
    private final WorldGenerator worldGenerator;
    private final LinkedListMultimap<Integer, ChunkCoords> chunkRegenList = LinkedListMultimap.create();

    public TickHandlerCoreServer(WorldGenerator worldGenerator) {
        this.worldGenerator = worldGenerator;
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Config.enableBackpackResupply) {
            for (Object obj : event.world.field_73010_i) {
                EntityPlayer player = (EntityPlayer)obj;
                for (IResupplyHandler handler : PluginManager.resupplyHandlers) {
                    handler.resupply(player);
                }
            }
        }
        if (Config.doRetrogen) {
            World world = event.world;
            int dimensionID = world.field_73011_w.field_76574_g;
            List chunkList = this.chunkRegenList.get((Object)dimensionID);
            if (chunkList.size() > 0) {
                ChunkCoords coords = (ChunkCoords)chunkList.get(0);
                chunkList.remove(0);
                long worldSeed = world.func_72905_C();
                Random random = new Random(worldSeed);
                long xSeed = random.nextLong() >> 3;
                long zSeed = random.nextLong() >> 3;
                random.setSeed(xSeed * (long)coords.xCoord + zSeed * (long)coords.zCoord ^ worldSeed);
                this.worldGenerator.retroGen(random, coords.xCoord, coords.zCoord, world);
            }
        }
    }

    @SubscribeEvent
    public void chunkSaveEventHandler(ChunkDataEvent.Save event) {
        NBTTagCompound tag = new NBTTagCompound();
        if (Config.doRetrogen) {
            tag.func_74757_a("retrogen", true);
        }
        event.getData().func_74782_a("Forestry", (NBTBase)tag);
    }

    @SubscribeEvent
    public void chunkLoadEventHandler(ChunkDataEvent.Load event) {
        NBTTagCompound tag;
        if (Config.doRetrogen && ((tag = (NBTTagCompound)event.getData().func_74781_a("Forestry")) == null || !tag.func_74764_b("retrogen") || Config.forceRetrogen)) {
            ChunkCoords coords = new ChunkCoords(event.getChunk());
            this.chunkRegenList.put((Object)coords.dimension, (Object)coords);
        }
    }
}

