/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.InvTools;
import forestry.core.utils.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public final class FluidHelper {
    public static final int BUCKET_FILL_TIME = 8;
    public static final int NETWORK_UPDATE_INTERVAL = 128;
    public static final int BUCKET_VOLUME = 1000;

    private FluidHelper() {
    }

    public static boolean handleRightClick(IFluidHandler tank, ForgeDirection side, EntityPlayer player, boolean fill, boolean drain) {
        if (player == null) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {
            ItemStack filled;
            FluidStack available;
            FluidStack liquid = FluidHelper.getFluidStackInContainer(current);
            if (fill && liquid != null) {
                int used = tank.fill(side, liquid, true);
                if (used > 0) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        ItemStack drainedContainer = FluidHelper.getDrainedContainer(current, used);
                        if (current.field_77994_a > 1) {
                            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                            if (drainedContainer != null && !player.field_71071_by.func_70441_a(drainedContainer)) {
                                player.func_71019_a(drainedContainer, false);
                            }
                        } else {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, drainedContainer);
                        }
                        player.field_71071_by.func_70296_d();
                    }
                    return true;
                }
            } else if (drain && (available = tank.drain(side, Integer.MAX_VALUE, false)) != null && (liquid = FluidHelper.getFluidStackInContainer(filled = FluidHelper.getFilledContainer(available, current))) != null) {
                if (current.field_77994_a > 1) {
                    if (!player.field_71071_by.func_70441_a(filled)) {
                        return false;
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(current));
                    player.field_71071_by.func_70296_d();
                } else {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(current));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                    player.field_71071_by.func_70296_d();
                }
                tank.drain(side, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public static void processContainers(StandardTank tank, IInventory inv, int inputSlot, int outputSlot) {
        FluidHelper.processContainers(tank, inv, inputSlot, outputSlot, tank.getFluidType(), true, true);
    }

    public static void processContainers(StandardTank tank, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean processFilled, boolean processEmpty) {
        TankManager tankManger = new TankManager();
        tankManger.add(tank);
        FluidHelper.processContainers(tankManger, inv, inputSlot, outputSlot, fluidToFill, processFilled, processEmpty);
    }

    public static void processContainers(TankManager tank, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill) {
        FluidHelper.processContainers(tank, inv, inputSlot, outputSlot, fluidToFill, true, true);
    }

    public static void processContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean processFilled, boolean processEmpty) {
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input == null) {
            return;
        }
        if (processFilled && FluidHelper.drainContainers(fluidHandler, inv, inputSlot, outputSlot)) {
            return;
        }
        if (processEmpty && fluidToFill != null) {
            FluidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill);
        }
    }

    public static boolean fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill) {
        return FluidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill, true);
    }

    public static boolean fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean doFill) {
        FluidStack fluidInContainer;
        FluidStack drain;
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        ItemStack filled = FluidHelper.getFilledContainer(fluidToFill, input);
        if (filled != null && (output == null || output.field_77994_a < output.func_77976_d() && InvTools.isItemEqual(filled, output)) && (drain = fluidHandler.drain(ForgeDirection.UNKNOWN, fluidInContainer = FluidHelper.getFluidStackInContainer(filled), false)) != null && drain.amount == fluidInContainer.amount) {
            if (doFill) {
                fluidHandler.drain(ForgeDirection.UNKNOWN, fluidInContainer, true);
                if (output == null) {
                    inv.func_70299_a(outputSlot, filled);
                } else {
                    ++output.field_77994_a;
                }
                inv.func_70298_a(inputSlot, 1);
            }
            return true;
        }
        return false;
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int slot) {
        return FluidHelper.drainContainers(fluidHandler, inv, slot, slot);
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot) {
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        if (input == null) {
            return false;
        }
        FluidStack fluidInContainer = FluidHelper.getFluidStackInContainer(input);
        if (fluidInContainer == null) {
            return false;
        }
        int used = fluidHandler.fill(ForgeDirection.UNKNOWN, fluidInContainer, false);
        if (used < fluidInContainer.amount) {
            return false;
        }
        ItemStack emptyItem = FluidHelper.getEmptyContainer(input);
        if (output != null && emptyItem != null) {
            if (outputSlot == inputSlot) {
                if (input.field_77994_a > 1) {
                    return false;
                }
            } else {
                if (!StackUtils.isIdenticalItem(output, emptyItem)) {
                    return false;
                }
                if (output.field_77994_a + emptyItem.field_77994_a > output.func_77976_d()) {
                    return false;
                }
            }
        }
        fluidHandler.fill(ForgeDirection.UNKNOWN, fluidInContainer, true);
        if (emptyItem != null) {
            if (outputSlot == inputSlot) {
                inv.func_70299_a(outputSlot, emptyItem);
                return true;
            }
            if (output == null) {
                inv.func_70299_a(outputSlot, emptyItem);
            } else {
                ++output.field_77994_a;
            }
        }
        inv.func_70298_a(inputSlot, 1);
        return true;
    }

    public static boolean isContainer(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IFluidContainerItem) {
            return true;
        }
        return FluidContainerRegistry.isContainer((ItemStack)stack);
    }

    public static boolean isFilledContainer(ItemStack stack) {
        if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
            return true;
        }
        Item item = stack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            FluidStack fluidStack = containerItem.getFluid(stack);
            return fluidStack != null && fluidStack.amount > 0;
        }
        return false;
    }

    public static boolean isFillableContainer(ItemStack stack, FluidStack liquid) {
        ItemStack empty = StackUtils.createSplitStack(stack, 1);
        Item item = empty.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            return containerItem.fill(empty, liquid, false) > 0;
        }
        for (FluidContainerRegistry.FluidContainerData cont : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!cont.fluid.isFluidEqual(liquid) || cont.emptyContainer == null || !cont.emptyContainer.func_77969_a(empty)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyContainer(ItemStack empty) {
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)empty)) {
            return true;
        }
        Item item = empty.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            FluidStack fluid = containerItem.getFluid(empty);
            return fluid == null || fluid.amount == 0;
        }
        return false;
    }

    public static ItemStack getEmptyContainer(ItemStack container) {
        Item item = container.func_77973_b();
        if (item == null) {
            return null;
        }
        return item.getContainerItem(container);
    }

    public static ItemStack getDrainedContainer(ItemStack container, int drainAmount) {
        if (container == null) {
            return null;
        }
        if (drainAmount == 0) {
            return container;
        }
        Item item = container.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            ItemStack drained = container.func_77946_l();
            drained.field_77994_a = 1;
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            containerItem.drain(drained, drainAmount, true);
            return drained;
        }
        return FluidHelper.getEmptyContainer(container);
    }

    public static ItemStack getFilledContainer(Fluid fluid, ItemStack empty) {
        if (fluid == null) {
            return null;
        }
        FluidStack fluidToFill = new FluidStack(fluid, Integer.MAX_VALUE);
        return FluidHelper.getFilledContainer(fluidToFill, empty);
    }

    public static ItemStack getFilledContainer(FluidStack liquid, ItemStack empty) {
        if (liquid == null || empty == null) {
            return null;
        }
        Item item = empty.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            ItemStack full = empty.func_77946_l();
            full.field_77994_a = 1;
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            containerItem.fill(full, liquid, true);
            return full;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)empty);
    }

    public static FluidStack getFluidStackInContainer(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            return containerItem.getFluid(stack);
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
    }

    public static Fluid getFluidInContainer(ItemStack stack) {
        FluidStack fluidStack = FluidHelper.getFluidStackInContainer(stack);
        return fluidStack != null ? fluidStack.getFluid() : null;
    }

    public static boolean containsFluidStack(ItemStack stack, FluidStack fluidStack) {
        Item item = stack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            FluidStack contained = containerItem.getFluid(stack);
            return contained != null && contained.containsFluid(fluidStack);
        }
        return FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)fluidStack);
    }

    public static boolean containsFluid(ItemStack stack, Fluid fluid) {
        return FluidHelper.containsFluidStack(stack, new FluidStack(fluid, 1));
    }

    public static FluidStack drainBlock(World world, int x, int y, int z, boolean doDrain) {
        return FluidHelper.drainBlock(world.func_147439_a(x, y, z), world, x, y, z, doDrain);
    }

    public static FluidStack drainBlock(Block block, World world, int x, int y, int z, boolean doDrain) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            if (fluidBlock.canDrain(world, x, y, z)) {
                return fluidBlock.drain(world, x, y, z, doDrain);
            }
        } else {
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                int meta = world.func_72805_g(x, y, z);
                if (meta != 0) {
                    return null;
                }
                if (doDrain) {
                    world.func_147468_f(x, y, z);
                }
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                int meta = world.func_72805_g(x, y, z);
                if (meta != 0) {
                    return null;
                }
                if (doDrain) {
                    world.func_147468_f(x, y, z);
                }
                return new FluidStack(FluidRegistry.LAVA, 1000);
            }
        }
        return null;
    }

    public static boolean isFullFluidBlock(World world, int x, int y, int z) {
        return FluidHelper.isFullFluidBlock(world.func_147439_a(x, y, z), world, x, y, z);
    }

    public static boolean isFullFluidBlock(Block block, World world, int x, int y, int z) {
        if (block instanceof BlockLiquid || block instanceof IFluidBlock) {
            return world.func_72805_g(x, y, z) == 0;
        }
        return false;
    }

    public static Fluid getFluid(Block block) {
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).getFluid();
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return FluidRegistry.WATER;
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return FluidRegistry.LAVA;
        }
        return null;
    }
}

